/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.application;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IApplication;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;

public class LayoutCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    private final String layout;

    public LayoutCommand(IModel model, S surface) {
        this(null, model, surface);
    }

    public LayoutCommand(String layout, IModel model, S surface) {
        super(model, surface);
        this.layout = layout;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        IApplication application = this.model.getApplication();
        if (this.layout == null) {
            application.nextPanelLayout();
        } else {
            application.setPanelLayout(this.layout);
        }
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event == ButtonEvent.DOWN) {
            this.model.getApplication().setPanelLayout("EDIT");
        }
    }
}

