/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.osc.module;

import de.mossgrabers.controller.osc.OSCConfiguration;
import de.mossgrabers.controller.osc.OSCControlSurface;
import de.mossgrabers.controller.osc.exception.IllegalParameterException;
import de.mossgrabers.controller.osc.exception.MissingCommandException;
import de.mossgrabers.controller.osc.exception.UnknownCommandException;
import de.mossgrabers.controller.osc.module.AbstractModule;
import de.mossgrabers.framework.command.trigger.transport.PlayCommand;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.clip.IClip;
import de.mossgrabers.framework.daw.constants.AutomationMode;
import de.mossgrabers.framework.daw.constants.LaunchQuantization;
import de.mossgrabers.framework.daw.constants.PostRecordingAction;
import de.mossgrabers.framework.osc.IOpenSoundControlWriter;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.LinkedList;
import java.util.Locale;

public class TransportModule
extends AbstractModule {
    private static final String TAG_LAUNCHER = "launcher";
    private final ITransport transport;
    private final PlayCommand<OSCControlSurface, OSCConfiguration> playCommand;

    public TransportModule(IHost host, IModel model, OSCControlSurface surface, IOpenSoundControlWriter writer) {
        super(host, model, writer);
        this.transport = model.getTransport();
        this.playCommand = new PlayCommand(model, surface);
    }

    @Override
    public String[] getSupportedCommands() {
        return new String[]{"play", "playbutton", "stop", "restart", "record", "overdub", "repeat", "punchIn", "punchOut", "click", "quantize", "tempo", "time", "position", "crossfade", "autowrite", "automationWriteMode", "preroll", TAG_LAUNCHER};
    }

    @Override
    public void execute(String command, LinkedList<String> path, Object value) throws IllegalParameterException, UnknownCommandException, MissingCommandException {
        boolean isTrigger = TransportModule.isTrigger(value);
        block21 : switch (command) {
            case "play": {
                boolean isPlaying = this.transport.isPlaying();
                if ((!isTrigger || isPlaying) && (isTrigger || !isPlaying)) break;
                this.transport.play();
                break;
            }
            case "playbutton": {
                if (!isTrigger) break;
                this.playCommand.execute(ButtonEvent.DOWN, 127);
                break;
            }
            case "stop": {
                if (this.transport.isPlaying()) {
                    this.transport.stop();
                    break;
                }
                this.transport.stopAndRewind();
                break;
            }
            case "restart": {
                if (!isTrigger) break;
                this.transport.restart();
                break;
            }
            case "record": {
                this.transport.startRecording();
                break;
            }
            case "overdub": {
                if (!path.isEmpty() && TAG_LAUNCHER.equals(path.get(0))) {
                    this.transport.toggleLauncherOverdub();
                    break;
                }
                this.transport.toggleOverdub();
                break;
            }
            case "repeat": {
                if (value == null) {
                    this.transport.toggleLoop();
                    break;
                }
                this.transport.setLoop(isTrigger);
                break;
            }
            case "punchIn": {
                if (value == null) {
                    this.transport.togglePunchIn();
                    break;
                }
                this.transport.setPunchIn(isTrigger);
                break;
            }
            case "punchOut": {
                if (value == null) {
                    this.transport.togglePunchOut();
                    break;
                }
                this.transport.setPunchOut(isTrigger);
                break;
            }
            case "click": {
                String subCommand;
                if (path.isEmpty()) {
                    if (value == null) {
                        this.transport.toggleMetronome();
                        break;
                    }
                    this.transport.setMetronome(isTrigger);
                    break;
                }
                switch (subCommand = TransportModule.getSubCommand(path)) {
                    case "volume": {
                        this.transport.setMetronomeVolume(TransportModule.toInteger(value));
                        break block21;
                    }
                    case "ticks": {
                        if (value == null) {
                            this.transport.toggleMetronomeTicks();
                            break block21;
                        }
                        this.transport.setMetronomeTicks(isTrigger);
                        break block21;
                    }
                    case "preroll": {
                        if (!isTrigger) break block21;
                        this.transport.togglePrerollMetronome();
                        break block21;
                    }
                    default: {
                        throw new UnknownCommandException(subCommand);
                    }
                }
            }
            case "quantize": {
                IClip clip = this.getClip();
                if (!clip.doesExist()) break;
                clip.quantize(1.0);
                break;
            }
            case "tempo": {
                String tempoCommand;
                switch (tempoCommand = TransportModule.getSubCommand(path)) {
                    case "raw": {
                        this.transport.setTempo(TransportModule.toNumber(value));
                        break block21;
                    }
                    case "tap": {
                        if (!isTrigger) break block21;
                        this.transport.tapTempo();
                        break block21;
                    }
                    case "+": {
                        this.transport.setTempo(this.transport.getTempo() + TransportModule.toNumber(value, 1.0));
                        break block21;
                    }
                    case "-": {
                        this.transport.setTempo(this.transport.getTempo() - TransportModule.toNumber(value, 1.0));
                        break block21;
                    }
                    default: {
                        throw new UnknownCommandException(tempoCommand);
                    }
                }
            }
            case "time": {
                this.transport.setPosition(TransportModule.toNumber(value));
                break;
            }
            case "position": {
                String positionCommand;
                if (path.isEmpty()) {
                    double numValue = TransportModule.toNumber(value);
                    this.transport.changePosition(numValue >= 0.0, Math.abs(numValue) <= 1.0);
                    break;
                }
                switch (positionCommand = path.get(0)) {
                    case "+": {
                        this.transport.changePosition(true, true);
                        break block21;
                    }
                    case "-": {
                        this.transport.changePosition(false, true);
                        break block21;
                    }
                    case "++": {
                        this.transport.changePosition(true, false);
                        break block21;
                    }
                    case "--": {
                        this.transport.changePosition(false, false);
                        break block21;
                    }
                    case "start": {
                        this.transport.setPosition(0.0);
                        break block21;
                    }
                }
                throw new UnknownCommandException(positionCommand);
            }
            case "crossfade": {
                if (path.isEmpty()) {
                    this.transport.setCrossfade(TransportModule.toInteger(value));
                    break;
                }
                if (!"reset".equals(path.get(0))) break;
                this.transport.getCrossfadeParameter().resetValue();
                break;
            }
            case "autowrite": {
                if (!path.isEmpty() && TAG_LAUNCHER.equals(path.get(0))) {
                    this.transport.toggleWriteClipLauncherAutomation();
                    break;
                }
                this.transport.toggleWriteArrangerAutomation();
                break;
            }
            case "automationWriteMode": {
                if (value == null) break;
                this.transport.setAutomationWriteMode(AutomationMode.valueOf(value.toString().toUpperCase(Locale.US)));
                break;
            }
            case "preroll": {
                this.transport.setPrerollMeasures(TransportModule.toInteger(value));
                break;
            }
            case "launcher": {
                String launcherCommand;
                switch (launcherCommand = path.get(0)) {
                    case "postRecordingAction": {
                        this.transport.setClipLauncherPostRecordingAction(PostRecordingAction.lookup(value.toString()));
                        break block21;
                    }
                    case "postRecordingTimeOffset": {
                        double beats = Math.clamp(TransportModule.toNumber(value), 0.0, 4000.0);
                        this.transport.setClipLauncherPostRecordingTimeOffset(beats);
                        break block21;
                    }
                    case "defaultQuantization": {
                        this.transport.setDefaultLaunchQuantization(LaunchQuantization.lookup(value.toString()));
                        break block21;
                    }
                }
                throw new UnknownCommandException(launcherCommand);
            }
            default: {
                throw new UnknownCommandException(command);
            }
        }
    }

    @Override
    public void flush(boolean dump) {
        this.writer.sendOSC("/play", this.transport.isPlaying(), dump);
        this.writer.sendOSC("/record", this.transport.isRecording(), dump);
        this.writer.sendOSC("/overdub", this.transport.isArrangerOverdub(), dump);
        this.writer.sendOSC("/overdub/launcher", this.transport.isLauncherOverdub(), dump);
        this.writer.sendOSC("/repeat", this.transport.isLoop(), dump);
        this.writer.sendOSC("/punchIn", this.transport.isPunchInEnabled(), dump);
        this.writer.sendOSC("/punchOut", this.transport.isPunchOutEnabled(), dump);
        this.writer.sendOSC("/click", this.transport.isMetronomeOn(), dump);
        this.writer.sendOSC("/click/ticks", this.transport.isMetronomeTicksOn(), dump);
        this.writer.sendOSC("/click/volume", this.transport.getMetronomeVolume(), dump);
        this.writer.sendOSC("/click/volumeStr", this.transport.getMetronomeVolumeStr(), dump);
        this.writer.sendOSC("/click/preroll", this.transport.isPrerollMetronomeEnabled(), dump);
        this.writer.sendOSC("/preroll", this.transport.getPrerollMeasures(), dump);
        this.writer.sendOSC("/tempo/raw", this.transport.getTempo(), dump);
        this.writer.sendOSC("/crossfade", this.transport.getCrossfade(), dump);
        this.writer.sendOSC("/autowrite", this.transport.isWritingArrangerAutomation(), dump);
        this.writer.sendOSC("/autowrite/launcher", this.transport.isWritingClipLauncherAutomation(), dump);
        this.writer.sendOSC("/automationWriteMode", this.transport.getAutomationWriteMode().getIdentifier(), dump);
        this.writer.sendOSC("/time/str", this.transport.getPositionText(), dump);
        this.writer.sendOSC("/time/signature", this.transport.getNumerator() + " / " + this.transport.getDenominator(), dump);
        this.writer.sendOSC("/beat/str", this.transport.getBeatText(), dump);
        this.writer.sendOSC("/launcher/postRecordingAction", this.transport.getClipLauncherPostRecordingAction().getIdentifier(), dump);
        this.writer.sendOSC("/launcher/postRecordingTimeOffset", this.transport.getClipLauncherPostRecordingTimeOffset(), dump);
        this.writer.sendOSC("/launcher/defaultQuantization", this.transport.getDefaultLaunchQuantization().getValue(), dump);
    }
}

