/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchkey.maxi.mode;

import de.mossgrabers.controller.novation.launchkey.maxi.LaunchkeyMk3Configuration;
import de.mossgrabers.controller.novation.launchkey.maxi.controller.LaunchkeyMk3ControlSurface;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.mode.track.TrackPanMode;
import java.util.List;

public class LaunchkeyMk3PanningMode
extends TrackPanMode<LaunchkeyMk3ControlSurface, LaunchkeyMk3Configuration> {
    public LaunchkeyMk3PanningMode(LaunchkeyMk3ControlSurface surface, IModel model, List<ContinuousID> controls) {
        super(surface, model, true, controls);
    }

    @Override
    public void updateDisplay() {
        ITextDisplay d = ((LaunchkeyMk3ControlSurface)this.surface).getTextDisplay();
        d.setCell(0, 0, "Pan   " + this.formatPageRange(" %d - %d"));
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        String trackText = cursorTrack.doesExist() ? String.format("%d: %s", cursorTrack.getPosition() + 1, cursorTrack.getName()) : "No sel. track";
        d.setCell(1, 0, trackText);
        ITrackBank tb = this.model.getCurrentTrackBank();
        for (int i = 0; i < 8; ++i) {
            ITrack t = (ITrack)tb.getItem(i);
            boolean exists = t.doesExist();
            int offset = i * 2;
            d.setCell(2 + offset, 0, exists ? String.format("%d: %s", t.getPosition() + 1, t.getName()) : "No track");
            d.setCell(2 + offset + 1, 0, (String)(exists ? "Pan: " + t.getPanStr() : ""));
        }
        d.allDone();
    }
}

