/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.command.trigger;

import de.mossgrabers.controller.ni.maschine.mk3.MaschineConfiguration;
import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.controller.ni.maschine.mk3.mode.MaschineUserMode;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.command.trigger.Direction;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.bank.ISlotBank;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class PageCommand
extends AbstractTriggerCommand<MaschineControlSurface, MaschineConfiguration> {
    private final Direction direction;

    public PageCommand(Direction direction, IModel model, MaschineControlSurface surface) {
        super(model, surface);
        this.direction = direction;
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ModeManager modeManager = ((MaschineControlSurface)this.surface).getModeManager();
        Modes mode = (Modes)((Object)modeManager.getActiveID());
        switch (mode) {
            case DEVICE_PARAMS: {
                ICursorDevice cursorDevice = this.model.getCursorDevice();
                if (this.direction == Direction.LEFT) {
                    cursorDevice.selectPrevious();
                } else {
                    cursorDevice.selectNext();
                }
                this.mvHelper.notifySelectedDevice();
                break;
            }
            case USER: {
                Object f = modeManager.get(Modes.USER);
                if (!(f instanceof MaschineUserMode)) break;
                MaschineUserMode userMode = (MaschineUserMode)f;
                userMode.setMode(this.direction == Direction.LEFT);
                break;
            }
            case BROWSER: {
                if (this.direction == Direction.LEFT) {
                    this.model.getBrowser().previousContentType();
                    break;
                }
                this.model.getBrowser().nextContentType();
                break;
            }
            default: {
                ICursorTrack cursorTrack = this.model.getCursorTrack();
                if (!cursorTrack.doesExist()) {
                    return;
                }
                ISlotBank slotBank = cursorTrack.getSlotBank();
                if (this.direction == Direction.LEFT) {
                    if (((MaschineControlSurface)this.surface).isShiftPressed()) {
                        ((MaschineControlSurface)this.surface).setStopConsumed();
                        slotBank.selectPreviousPage();
                        break;
                    }
                    slotBank.selectPreviousItem();
                    break;
                }
                if (((MaschineControlSurface)this.surface).isShiftPressed()) {
                    ((MaschineControlSurface)this.surface).setStopConsumed();
                    slotBank.selectNextPage();
                    break;
                }
                slotBank.selectNextItem();
            }
        }
    }
}

