/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.core;

import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.daw.DAWColor;
import java.util.List;

public class MaschineColorManager
extends ColorManager {
    public static final int COLOR_BLACK = 0;
    public static final int COLOR_DARK_GREY = 76;
    public static final int COLOR_GREY = 77;
    public static final int COLOR_WHITE = 78;
    public static final int COLOR_ROSE = 7;
    public static final int COLOR_RED = 6;
    public static final int COLOR_RED_LO = 5;
    public static final int COLOR_AMBER = 14;
    public static final int COLOR_AMBER_LO = 13;
    public static final int COLOR_LIME = 34;
    public static final int COLOR_LIME_LO = 33;
    public static final int COLOR_GREEN = 30;
    public static final int COLOR_GREEN_LO = 29;
    public static final int COLOR_SPRING = 26;
    public static final int COLOR_SPRING_LO = 25;
    public static final int COLOR_TURQUOISE_LO = 27;
    public static final int COLOR_TURQUOISE = 31;
    public static final int COLOR_SKY = 38;
    public static final int COLOR_SKY_LO = 37;
    public static final int COLOR_BLUE = 42;
    public static final int COLOR_BLUE_LO = 45;
    public static final int COLOR_MAGENTA = 58;
    public static final int COLOR_MAGENTA_LO = 57;
    public static final int COLOR_PINK = 62;
    public static final int COLOR_PINK_LO = 61;
    public static final int COLOR_ORANGE = 10;
    public static final int COLOR_ORANGE_LO = 9;
    public static final int COLOR_PURPLE = 50;
    public static final int COLOR_PURPLE_LO = 53;
    public static final int COLOR_SKIN = 11;
    public static final int COLOR_YELLOW_LO = 21;
    public static final int COLOR_YELLOW = 22;
    public static final List<Integer> PARAM_COLORS = List.of(Integer.valueOf(6), Integer.valueOf(14), Integer.valueOf(22), Integer.valueOf(30), Integer.valueOf(34), Integer.valueOf(38), Integer.valueOf(50), Integer.valueOf(62));

    public MaschineColorManager() {
        this.registerColorIndex("GRID_COLOR_OFF", 0);
        this.registerColorIndex("BUTTON_STATE_OFF", 0);
        this.registerColorIndex("BUTTON_STATE_ON", 0);
        this.registerColorIndex("BUTTON_STATE_HI", 127);
        this.registerColorIndex("SCALE_COLOR_OFF", 0);
        this.registerColorIndex("SCALE_COLOR_OCTAVE", 42);
        this.registerColorIndex("SCALE_COLOR_NOTE", 78);
        this.registerColorIndex("SCALE_COLOR_OUT_OF_SCALE", 0);
        this.registerColorIndex("BUTTON_COLOR_OFF", 0);
        this.registerColorIndex("BUTTON_COLOR_ON", 0);
        this.registerColorIndex("BUTTON_COLOR_HI", 127);
        this.registerColorIndex("PLAY_VIEW_COLOR_PLAY", 30);
        this.registerColorIndex("PLAY_VIEW_COLOR_RECORD", 6);
        this.registerColorIndex("PLAY_VIEW_COLOR_OFF", 0);
        this.registerColorIndex("COLOR_STEP_HILITE_NO_CONTENT", 29);
        this.registerColorIndex("COLOR_STEP_HILITE_CONTENT", 30);
        this.registerColorIndex("COLOR_STEP_MUTED", 76);
        this.registerColorIndex("COLOR_STEP_MUTED_CONT", 77);
        this.registerColorIndex("COLOR_STEP_SELECTED", 22);
        this.registerColorIndex("COLOR_NO_CONTENT", 0);
        this.registerColorIndex("COLOR_NO_CONTENT_4", 0);
        this.registerColorIndex("COLOR_CONTENT", 42);
        this.registerColorIndex("COLOR_CONTENT_CONT", 45);
        this.registerColorIndex("COLOR_PAGE", 77);
        this.registerColorIndex("COLOR_ACTIVE_PAGE", 30);
        this.registerColorIndex("COLOR_SELECTED_PAGE", 42);
        this.registerColorIndex("COLOR_RESOLUTION", 10);
        this.registerColorIndex("COLOR_RESOLUTION_SELECTED", 6);
        this.registerColorIndex("COLOR_RESOLUTION_OFF", 0);
        this.registerColorIndex("COLOR_PAD_OFF", 0);
        this.registerColorIndex("COLOR_PAD_RECORD", 6);
        this.registerColorIndex("COLOR_PAD_PLAY", 30);
        this.registerColorIndex("COLOR_PAD_SELECTED", 42);
        this.registerColorIndex("COLOR_PAD_MUTED", 14);
        this.registerColorIndex("COLOR_PAD_HAS_CONTENT", 34);
        this.registerColorIndex("COLOR_PAD_NO_CONTENT", 76);
        this.registerColorIndex("BROWSER_OFF", 0);
        this.registerColorIndex("BROWSER_DISCARD", 6);
        this.registerColorIndex("BROWSER_CONFIRM", 30);
        this.registerColorIndex("BROWSER_PLAY", 13);
        this.registerColorIndex("BROWSER_COLUMN1", 78);
        this.registerColorIndex("BROWSER_COLUMN2", 77);
        this.registerColorIndex("BROWSER_COLUMN3", 76);
        this.registerColorIndex("BROWSER_COLUMN4", 7);
        this.registerColorIndex("BROWSER_COLUMN5", 26);
        this.registerColorIndex("BROWSER_COLUMN6", 45);
        this.registerColorIndex("BROWSER_COLUMN7", 0);
        this.registerColorIndex("BROWSER_COLUMN8", 22);
        this.registerColorIndex(DAWColor.COLOR_OFF, 0);
        this.registerColorIndex(DAWColor.DAW_COLOR_GRAY_HALF, 76);
        this.registerColorIndex(DAWColor.DAW_COLOR_DARK_GRAY, 76);
        this.registerColorIndex(DAWColor.DAW_COLOR_GRAY, 77);
        this.registerColorIndex(DAWColor.DAW_COLOR_LIGHT_GRAY, 77);
        this.registerColorIndex(DAWColor.DAW_COLOR_SILVER, 77);
        this.registerColorIndex(DAWColor.DAW_COLOR_DARK_BROWN, 13);
        this.registerColorIndex(DAWColor.DAW_COLOR_BROWN, 13);
        this.registerColorIndex(DAWColor.DAW_COLOR_DARK_BLUE, 45);
        this.registerColorIndex(DAWColor.DAW_COLOR_PURPLE_BLUE, 53);
        this.registerColorIndex(DAWColor.DAW_COLOR_PURPLE, 50);
        this.registerColorIndex(DAWColor.DAW_COLOR_PINK, 62);
        this.registerColorIndex(DAWColor.DAW_COLOR_RED, 6);
        this.registerColorIndex(DAWColor.DAW_COLOR_ORANGE, 10);
        this.registerColorIndex(DAWColor.DAW_COLOR_LIGHT_ORANGE, 22);
        this.registerColorIndex(DAWColor.DAW_COLOR_MOSS_GREEN, 33);
        this.registerColorIndex(DAWColor.DAW_COLOR_GREEN, 26);
        this.registerColorIndex(DAWColor.DAW_COLOR_COLD_GREEN, 31);
        this.registerColorIndex(DAWColor.DAW_COLOR_BLUE, 42);
        this.registerColorIndex(DAWColor.DAW_COLOR_LIGHT_PURPLE, 58);
        this.registerColorIndex(DAWColor.DAW_COLOR_LIGHT_PINK, 62);
        this.registerColorIndex(DAWColor.DAW_COLOR_ROSE, 11);
        this.registerColorIndex(DAWColor.DAW_COLOR_REDDISH_BROWN, 14);
        this.registerColorIndex(DAWColor.DAW_COLOR_LIGHT_BROWN, 13);
        this.registerColorIndex(DAWColor.DAW_COLOR_LIGHT_GREEN, 26);
        this.registerColorIndex(DAWColor.DAW_COLOR_BLUISH_GREEN, 34);
        this.registerColorIndex(DAWColor.DAW_COLOR_GREEN_BLUE, 27);
        this.registerColorIndex(DAWColor.DAW_COLOR_LIGHT_BLUE, 38);
        this.registerColor(0, ColorEx.BLACK);
        this.registerColor(76, ColorEx.DARK_GRAY);
        this.registerColor(77, ColorEx.GRAY);
        this.registerColor(78, ColorEx.WHITE);
        this.registerColor(7, DAWColor.DAW_COLOR_ROSE.getColor());
        this.registerColor(6, DAWColor.DAW_COLOR_REDDISH_BROWN.getColor());
        this.registerColor(5, ColorEx.fromRGB(39, 4, 1));
        this.registerColor(14, DAWColor.DAW_COLOR_REDDISH_BROWN.getColor());
        this.registerColor(13, DAWColor.DAW_COLOR_DARK_BROWN.getColor());
        this.registerColor(21, ColorEx.darker(ColorEx.fromRGB(107, 105, 1)));
        this.registerColor(22, ColorEx.fromRGB(107, 105, 1));
        this.registerColor(34, ColorEx.fromRGB(29, 104, 1));
        this.registerColor(33, DAWColor.DAW_COLOR_MOSS_GREEN.getColor());
        this.registerColor(30, ColorEx.fromRGB(1, 104, 1));
        this.registerColor(29, ColorEx.fromRGB(1, 36, 1));
        this.registerColor(26, DAWColor.DAW_COLOR_GREEN.getColor());
        this.registerColor(25, ColorEx.fromRGB(1, 36, 1));
        this.registerColor(27, ColorEx.fromRGB(1, 248, 75));
        this.registerColor(31, DAWColor.DAW_COLOR_COLD_GREEN.getColor());
        this.registerColor(38, ColorEx.fromRGB(1, 82, 100));
        this.registerColor(37, ColorEx.fromRGB(1, 26, 37));
        this.registerColor(42, ColorEx.fromRGB(4, 23, 110));
        this.registerColor(45, ColorEx.fromRGB(1, 8, 38));
        this.registerColor(58, ColorEx.fromRGB(110, 28, 109));
        this.registerColor(57, ColorEx.fromRGB(39, 9, 38));
        this.registerColor(62, ColorEx.fromRGB(110, 20, 40));
        this.registerColor(61, ColorEx.fromRGB(48, 9, 26));
        this.registerColor(10, DAWColor.DAW_COLOR_ORANGE.getColor());
        this.registerColor(9, ColorEx.DARK_ORANGE);
        this.registerColor(50, ColorEx.PURPLE);
        this.registerColor(53, ColorEx.PURPLE);
        this.registerColor(11, ColorEx.ROSE);
    }

    public int dimOrHighlightColor(ColorEx color, boolean isSelected) {
        int colorIndex = this.getColorIndex(DAWColor.getColorID(color));
        if (isSelected) {
            return colorIndex == 76 ? 78 : colorIndex;
        }
        return colorIndex / 8 * 8 + 5;
    }

    @Override
    public ColorEx getColor(int colorIndex, ButtonID buttonID) {
        if (colorIndex < 0) {
            return ColorEx.BLACK;
        }
        if (buttonID == null) {
            return ColorEx.GRAY;
        }
        if (buttonID.ordinal() >= ButtonID.PAD1.ordinal() && buttonID.ordinal() <= ButtonID.PAD64.ordinal()) {
            return super.getColor(colorIndex, buttonID);
        }
        switch (buttonID) {
            case PLAY: {
                return colorIndex > 0 ? ColorEx.GREEN : ColorEx.DARK_GREEN;
            }
            case RECORD: {
                return colorIndex > 0 ? ColorEx.RED : ColorEx.DARK_RED;
            }
            case ROW3_1: 
            case ROW3_2: 
            case ROW3_3: 
            case ROW3_4: 
            case ROW3_5: 
            case ROW3_6: 
            case ROW3_7: 
            case ROW3_8: {
                return super.getColor(colorIndex, buttonID);
            }
        }
        return colorIndex > 0 ? ColorEx.WHITE : ColorEx.GRAY;
    }
}

