/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.hui.mode.track;

import de.mossgrabers.controller.mackie.hui.HUIConfiguration;
import de.mossgrabers.controller.mackie.hui.controller.HUIControlSurface;
import de.mossgrabers.controller.mackie.hui.mode.track.AbstractTrackMode;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import java.util.Optional;

public class TrackMode
extends AbstractTrackMode {
    public TrackMode(HUIControlSurface surface, IModel model) {
        super("Track", surface, model);
    }

    @Override
    public void onKnobValue(int index, int value) {
        int extenderOffset = ((HUIControlSurface)this.surface).getExtenderOffset();
        if (extenderOffset > 0) {
            return;
        }
        Optional trackOpt = this.model.getTrackBank().getSelectedItem();
        if (!trackOpt.isPresent()) {
            return;
        }
        ITrack track = (ITrack)trackOpt.get();
        switch (index) {
            case 0: {
                track.changeVolume(value);
                break;
            }
            case 1: {
                track.changePan(value);
                break;
            }
            default: {
                ((ISend)track.getSendBank().getItem(index - 2)).changeValue(value);
            }
        }
    }

    @Override
    public void updateDisplay() {
        if (!((HUIConfiguration)((HUIControlSurface)this.surface).getConfiguration()).hasDisplay1()) {
            return;
        }
        ITextDisplay d = ((HUIControlSurface)this.surface).getTextDisplay().clear();
        Optional trackOpt = this.model.getTrackBank().getSelectedItem();
        if (trackOpt.isPresent() && ((HUIControlSurface)this.surface).getExtenderOffset() == 0) {
            d.setCell(0, 0, "Vol");
            d.setCell(0, 1, "Pan");
            d.setCell(0, 2, "S1");
            d.setCell(0, 3, "S2");
            d.setCell(0, 4, "S3");
            d.setCell(0, 5, "S4");
            d.setCell(0, 6, "S5");
            d.setCell(0, 7, "S6");
        } else {
            d.setRow(0, "Please select a track.");
        }
        d.done(0);
    }

    @Override
    public void updateKnobLEDs() {
        int upperBound = this.model.getValueChanger().getUpperBound();
        Optional selectedTrack = this.model.getTrackBank().getSelectedItem();
        if (selectedTrack.isPresent() && ((HUIControlSurface)this.surface).getExtenderOffset() == 0) {
            ITrack track = (ITrack)selectedTrack.get();
            ((HUIControlSurface)this.surface).setKnobLED(0, 2, Math.max(track.getVolume(), 1), upperBound);
            ((HUIControlSurface)this.surface).setKnobLED(1, 1, Math.max(track.getPan(), 1), upperBound);
            ISendBank sendBank = track.getSendBank();
            for (int i = 0; i < 6; ++i) {
                ((HUIControlSurface)this.surface).setKnobLED(2 + i, 2, Math.max(((ISend)sendBank.getItem(i)).getValue(), 1), upperBound);
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                ((HUIControlSurface)this.surface).setKnobLED(i, -1, 0, 0);
            }
        }
    }

    @Override
    public void resetParameter(int index) {
        Optional trackOpt = this.model.getTrackBank().getSelectedItem();
        if (!trackOpt.isPresent() || ((HUIControlSurface)this.surface).getExtenderOffset() > 0) {
            return;
        }
        ITrack track = (ITrack)trackOpt.get();
        switch (index) {
            case 0: {
                track.resetVolume();
                break;
            }
            case 1: {
                track.resetPan();
                break;
            }
            default: {
                ((ISend)track.getSendBank().getItem(index - 2)).resetValue();
            }
        }
    }
}

