/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.intuitiveinstruments.exquis.mode;

import de.mossgrabers.controller.intuitiveinstruments.exquis.ExquisConfiguration;
import de.mossgrabers.controller.intuitiveinstruments.exquis.controller.ExquisControlSurface;
import de.mossgrabers.controller.intuitiveinstruments.exquis.mode.ExquisFourKnobProvider;
import de.mossgrabers.controller.intuitiveinstruments.exquis.mode.IExquisMode;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.mode.device.ProjectParamsMode;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;

public class ExquisProjectTrackParameterMode
extends ProjectParamsMode<ExquisControlSurface, ExquisConfiguration>
implements IExquisMode {
    private static final int[] PARAM_COLORS = new int[]{DAWColor.DAW_COLOR_RED.ordinal(), DAWColor.DAW_COLOR_ORANGE.ordinal(), DAWColor.DAW_COLOR_LIGHT_ORANGE.ordinal(), DAWColor.DAW_COLOR_GREEN.ordinal()};

    public ExquisProjectTrackParameterMode(ExquisControlSurface surface, IModel model, boolean isProjectParameterMode) {
        super(surface, model, false, null, () -> false, false);
        this.setControls(ExquisControlSurface.KNOBS);
        this.isProjectMode = isProjectParameterMode;
        if (this.isProjectMode) {
            this.projectParameterProvider = new ExquisFourKnobProvider(surface, new BankParameterProvider(model.getProject().getParameterBank()));
            this.setParameterProvider(this.projectParameterProvider);
        } else {
            this.trackParameterProvider = new ExquisFourKnobProvider(surface, new BankParameterProvider(model.getCursorTrack().getParameterBank()));
            this.setParameterProvider(this.trackParameterProvider);
        }
    }

    public boolean areProjectParametersActive() {
        return this.isProjectMode;
    }

    @Override
    public int getKnobColor(int index) {
        return 50 + PARAM_COLORS[index];
    }

    @Override
    public void toggleParameters() {
        ((ExquisFourKnobProvider)(this.areProjectParametersActive() ? this.projectParameterProvider : this.trackParameterProvider)).toggle();
        this.bindControls();
    }

    public boolean are1To4Bound() {
        return ((ExquisFourKnobProvider)(this.areProjectParametersActive() ? this.projectParameterProvider : this.trackParameterProvider)).are1To4Bound();
    }
}

