/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire.controller;

import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.grid.BlinkingPadGrid;
import de.mossgrabers.framework.controller.grid.LightInfo;
import de.mossgrabers.framework.daw.midi.IMidiOutput;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class FirePadGrid
extends BlinkingPadGrid {
    static final int[] TRANSLATE_16x4_MATRIX = new int[]{102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69};
    private static final Map<Integer, Integer> INVERSE_TRANSLATE_16x4_MATRIX = new HashMap<Integer, Integer>(64);
    private double padBrightness = 1.0;
    private double padSaturation = 1.0;

    public FirePadGrid(ColorManager colorManager, IMidiOutput output) {
        super(colorManager, output, 4, 16, 36);
    }

    @Override
    public int translateToGrid(int note) {
        Integer value = INVERSE_TRANSLATE_16x4_MATRIX.get(note);
        return value == null ? -1 : value;
    }

    @Override
    public int[] translateToController(int note) {
        return new int[]{0, TRANSLATE_16x4_MATRIX[note - 36]};
    }

    @Override
    protected void updateController() {
        LightInfo info;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.padInfos.entrySet()) {
            int n = (Integer)entry.getKey();
            info = (LightInfo)entry.getValue();
            int index = n - 54;
            ColorEx color = this.colorManager.getColor(info.getColor(), ButtonID.PAD1);
            if (!color.equals(ColorEx.BLACK)) {
                color = color.scale(this.padBrightness, this.padSaturation);
            }
            int[] c = color.toIntRGB127();
            sb.append(StringUtils.toHexStr(index)).append(' ');
            sb.append(StringUtils.toHexStr(c[0])).append(' ');
            sb.append(StringUtils.toHexStr(c[1])).append(' ');
            sb.append(StringUtils.toHexStr(c[2])).append(' ');
            Integer key = index;
            if (info.getBlinkColor() > 0) {
                this.blinkingLights.put(key, info);
                continue;
            }
            this.blinkingLights.remove(key);
        }
        int length = this.padInfos.size();
        if (this.checkBlinking()) {
            length += this.blinkingLights.size();
            for (Map.Entry entry : this.blinkingLights.entrySet()) {
                info = (LightInfo)entry.getValue();
                int colorIndex = this.isBlink ? info.getBlinkColor() : info.getColor();
                int[] c = this.colorManager.getColor(colorIndex, ButtonID.PAD1).scale(this.padBrightness, this.padSaturation).toIntRGB127();
                sb.append(StringUtils.toHexStr((Integer)entry.getKey())).append(' ');
                sb.append(StringUtils.toHexStr(c[0])).append(' ');
                sb.append(StringUtils.toHexStr(c[1])).append(' ');
                sb.append(StringUtils.toHexStr(c[2])).append(' ');
            }
        }
        if (sb.length() == 0) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("F0 47 7F 43 65 ");
        stringBuilder.append(StringUtils.toHexStr((length *= 4) / 128)).append(' ');
        stringBuilder.append(StringUtils.toHexStr(length % 128)).append(' ');
        this.output.sendSysex(stringBuilder.append((CharSequence)sb).append("F7").toString());
    }

    void configureLEDs(double padBrightness, double padSaturation) {
        this.padBrightness = padBrightness;
        this.padSaturation = padSaturation;
    }

    static {
        for (int i = 0; i < TRANSLATE_16x4_MATRIX.length; ++i) {
            INVERSE_TRANSLATE_16x4_MATRIX.put(TRANSLATE_16x4_MATRIX[i], 36 + i);
        }
    }
}

