/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apc.view;

import de.mossgrabers.controller.akai.apc.APCConfiguration;
import de.mossgrabers.controller.akai.apc.controller.APCControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.AbstractPlayView;

public class PlayView
extends AbstractPlayView<APCControlSurface, APCConfiguration> {
    public PlayView(APCControlSurface surface, IModel model) {
        super("Play", surface, model, surface.isMkII());
    }

    @Override
    protected void playNote(int note, int velocity) {
        if (!((APCControlSurface)this.surface).isMkII()) {
            ((APCControlSurface)this.surface).sendMidiEvent(144, note, velocity);
        }
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        int index = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        if (index >= 0 && index < 8) {
            return index == 2 ? "BUTTON_STATE_OFF" : "BUTTON_STATE_ON";
        }
        return "BUTTON_STATE_OFF";
    }

    @Override
    public void onButton(ButtonID buttonID, ButtonEvent event, int velocity) {
        if (!ButtonID.isSceneButton(buttonID) || event != ButtonEvent.DOWN) {
            return;
        }
        switch (buttonID) {
            case SCENE1: {
                this.scales.nextScale();
                this.updateScale();
                ((APCControlSurface)this.surface).getDisplay().notify("Scale: " + this.scales.getScale().getName());
                break;
            }
            case SCENE2: {
                this.scales.prevScale();
                this.updateScale();
                ((APCControlSurface)this.surface).getDisplay().notify("Scale: " + this.scales.getScale().getName());
                break;
            }
            case SCENE3: {
                this.scales.toggleChromatic();
                boolean isChromatic = this.scales.isChromatic();
                ((APCConfiguration)((APCControlSurface)this.surface).getConfiguration()).setScaleInKey(!isChromatic);
                ((APCControlSurface)this.surface).getDisplay().notify(isChromatic ? "Chromatic" : "In Key");
                break;
            }
            case SCENE4: {
                this.onOctaveUp(event);
                break;
            }
            case SCENE5: {
                this.onOctaveDown(event);
                break;
            }
        }
        this.updateNoteMapping();
    }
}

