/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.Push1Display;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.BaseMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.scale.ScaleLayout;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;

public class ScaleLayoutMode
extends BaseMode<IItem> {
    private final Scales scales;

    public ScaleLayoutMode(PushControlSurface surface, IModel model) {
        super("Scale Layout", surface, model);
        this.scales = model.getScales();
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        int sl = this.scales.getScaleLayout().ordinal();
        String[] names = ScaleLayout.getNames();
        if (index < names.length / 2) {
            this.scales.setScaleLayout(ScaleLayout.getByName(names[index * 2 + sl % 2]));
        } else if (index == 7) {
            this.scales.setScaleLayout(ScaleLayout.getByName(names[sl / 2 * 2 + (sl % 2 == 0 ? 1 : 0)]));
        } else {
            return;
        }
        ((IView)((PushControlSurface)this.surface).getViewManager().getActive()).updateNoteMapping();
        ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).setScaleLayout(this.scales.getScaleLayout().getName());
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        int index = this.isButtonRow(0, buttonID);
        if (index >= 0) {
            int sl = this.scales.getScaleLayout().ordinal();
            int pos = sl / 2;
            if (index < ScaleLayout.getNames().length / 2) {
                return pos == index ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON";
            }
            return index == 7 ? "BUTTON_COLOR_ON" : "BUTTON_COLOR_OFF";
        }
        return "BUTTON_COLOR_OFF";
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        int sl = this.scales.getScaleLayout().ordinal();
        int pos = sl / 2;
        String[] names = ScaleLayout.getNames();
        display.setBlock(1, 0, "Scale layout:");
        for (int i = 0; i < names.length; i += 2) {
            display.setCell(3, i / 2, (pos == i / 2 ? Push1Display.SELECT_ARROW : " ") + names[i].replace(" ^", ""));
        }
        display.setCell(3, 7, sl % 2 == 0 ? "Horizontal" : "Vertical");
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        int sl = this.scales.getScaleLayout().ordinal();
        int pos = sl / 2;
        String[] names = ScaleLayout.getNames();
        for (int i = 0; i < names.length; i += 2) {
            display.addOptionElement("", "", false, i == 0 ? "Scale layout" : "", names[i].replace(" ^", ""), pos == i / 2, false);
        }
        display.addOptionElement("", "", false, "", "", false, false);
        display.addOptionElement("", "", false, "", sl % 2 == 0 ? "Horizontal" : "Vertical", false, false);
    }
}

