/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode;

import de.mossgrabers.controller.ableton.push.controller.Push1Display;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.BaseMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.StringUtils;
import de.mossgrabers.framework.view.Views;

public class NoteViewSelectMode
extends BaseMode<IItem> {
    private static final Views[] VIEWS = new Views[]{Views.PLAY, Views.CHORDS, Views.PIANO, Views.DRUM64, null, null, Views.CLIP_LENGTH, Views.PRG_CHANGE};
    private static final Views[] VIEWS_TOP = new Views[]{Views.SEQUENCER, Views.POLY_SEQUENCER, Views.RAINDROPS, null, Views.DRUM, Views.DRUM4, Views.DRUM8, Views.DRUM_XOX};

    public NoteViewSelectMode(PushControlSurface surface, IModel model) {
        super("Note View Select", surface, model);
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event == ButtonEvent.UP) {
            this.activateView(VIEWS[index]);
        }
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event == ButtonEvent.UP) {
            this.activateView(VIEWS_TOP[index]);
        }
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
        display.setBlock(1, 0, "Sequence:");
        display.setBlock(2, 0, "Play:");
        display.setBlock(2, 3, "Tools:");
        for (int i = 0; i < VIEWS.length; ++i) {
            Object value;
            IView view;
            if (VIEWS[i] != null) {
                view = (IView)viewManager.get(VIEWS[i]);
                value = "";
                if (view != null) {
                    value = (viewManager.isActive(new Views[]{VIEWS[i]}) ? Push1Display.SELECT_ARROW : "") + StringUtils.optimizeName(view.getName(), 8);
                }
                display.setCell(3, i, (String)value);
            }
            if (VIEWS_TOP[i] == null) continue;
            view = (IView)viewManager.get(VIEWS_TOP[i]);
            value = "";
            if (view != null) {
                value = (viewManager.isActive(new Views[]{VIEWS_TOP[i]}) ? Push1Display.SELECT_ARROW : "") + StringUtils.optimizeName(view.getName(), 8);
            }
            display.setCell(0, i, (String)value);
        }
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
        for (int i = 0; i < VIEWS.length; ++i) {
            IView view;
            String menuBottomName = "";
            if (VIEWS[i] != null && (view = (IView)viewManager.get(VIEWS[i])) != null) {
                menuBottomName = view.getName();
            }
            String menuTopName = VIEWS_TOP[i] == null ? "" : ((IView)viewManager.get(VIEWS_TOP[i])).getName();
            boolean isMenuBottomSelected = VIEWS[i] != null && viewManager.isActive(new Views[]{VIEWS[i]});
            boolean isMenuTopSelected = VIEWS_TOP[i] != null && viewManager.isActive(new Views[]{VIEWS_TOP[i]});
            String titleBottom = "";
            String titleTop = "";
            if (i == 0) {
                titleTop = "Sequence";
                titleBottom = "Play";
            } else if (i == 6) {
                titleBottom = "Tools";
            }
            display.addOptionElement(titleTop, menuTopName, isMenuTopSelected, titleBottom, menuBottomName, isMenuBottomSelected, false);
        }
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        int index = this.isButtonRow(0, buttonID);
        if (index >= 0) {
            ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
            if (VIEWS[index] == null) {
                return "BUTTON_COLOR_OFF";
            }
            return viewManager.isActive(new Views[]{VIEWS[index]}) ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON";
        }
        index = this.isButtonRow(1, buttonID);
        if (index >= 0) {
            ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
            if (VIEWS_TOP[index] == null) {
                return "BUTTON_COLOR_OFF";
            }
            return viewManager.isActive(new Views[]{VIEWS_TOP[index]}) ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON";
        }
        return "BUTTON_COLOR_OFF";
    }

    private void activateView(Views viewID) {
        this.activatePreferredView(viewID);
        ((PushControlSurface)this.surface).getModeManager().restore();
    }
}

