/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.Push1Display;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.BaseMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.color.ColorManager;
import de.mossgrabers.framework.controller.display.Format;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.GrooveParameterID;
import de.mossgrabers.framework.daw.IGroove;
import de.mossgrabers.framework.daw.IHost;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.daw.midi.ArpeggiatorMode;
import de.mossgrabers.framework.daw.midi.INoteInput;
import de.mossgrabers.framework.daw.midi.INoteRepeat;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.utils.Pair;
import de.mossgrabers.framework.utils.StringUtils;
import java.util.List;

public class NoteRepeatMode
extends BaseMode<IItem> {
    private final IHost host;
    private final INoteRepeat noteRepeat;

    public NoteRepeatMode(PushControlSurface surface, IModel model) {
        super("Note Repeat", surface, model);
        this.host = this.model.getHost();
        INoteInput defaultNoteInput = surface.getMidiInput().getDefaultNoteInput();
        this.noteRepeat = defaultNoteInput == null ? null : defaultNoteInput.getNoteRepeat();
    }

    @Override
    public void onActivate() {
        super.onActivate();
        this.model.getGroove().enableObservers(true);
    }

    @Override
    public void onDeactivate() {
        super.onDeactivate();
        this.model.getGroove().enableObservers(false);
    }

    @Override
    public void onKnobValue(int index, int value) {
        if (index != 7 && !this.increaseKnobMovement()) {
            return;
        }
        PushConfiguration configuration = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        IValueChanger valueChanger = this.model.getValueChanger();
        switch (index) {
            case 0: 
            case 1: {
                int sel = Resolution.change(Resolution.getMatch(configuration.getNoteRepeatPeriod().getValue()), valueChanger.isIncrease(value));
                configuration.setNoteRepeatPeriod(Resolution.values()[sel]);
                break;
            }
            case 2: 
            case 3: {
                if (!this.host.supports(Capability.NOTE_REPEAT_LENGTH)) break;
                int sel2 = Resolution.change(Resolution.getMatch(configuration.getNoteRepeatLength().getValue()), valueChanger.calcKnobChange(value) > 0.0);
                configuration.setNoteRepeatLength(Resolution.values()[sel2]);
                break;
            }
            case 5: {
                if (!this.host.supports(Capability.NOTE_REPEAT_MODE)) break;
                configuration.setPrevNextNoteRepeatMode(valueChanger.isIncrease(value));
                break;
            }
            case 6: {
                if (!this.host.supports(Capability.NOTE_REPEAT_OCTAVES)) break;
                configuration.setNoteRepeatOctave(configuration.getNoteRepeatOctave() + (valueChanger.calcKnobChange(value) > 0.0 ? 1 : -1));
                break;
            }
            case 7: {
                if (!this.host.supports(Capability.NOTE_REPEAT_SWING)) break;
                this.model.getGroove().getParameter(GrooveParameterID.SHUFFLE_AMOUNT).changeValue(value);
                break;
            }
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.setTouchedKnob(index, isTouched);
        if (isTouched && ((PushControlSurface)this.surface).isDeletePressed()) {
            ((PushControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
            switch (index) {
                case 5: {
                    if (!this.host.supports(Capability.NOTE_REPEAT_MODE)) break;
                    this.noteRepeat.setMode(ArpeggiatorMode.UP);
                    break;
                }
                case 6: {
                    if (!this.host.supports(Capability.NOTE_REPEAT_OCTAVES)) break;
                    this.noteRepeat.setOctaves(1);
                    break;
                }
                case 7: {
                    if (!this.host.supports(Capability.NOTE_REPEAT_SWING)) break;
                    this.model.getGroove().getParameter(GrooveParameterID.SHUFFLE_AMOUNT).resetValue();
                    break;
                }
            }
        }
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP || this.noteRepeat == null) {
            return;
        }
        PushConfiguration configuration = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        switch (index) {
            case 0: 
            case 1: {
                int sel = Resolution.change(Resolution.getMatch(this.noteRepeat.getPeriod()), index == 1);
                configuration.setNoteRepeatPeriod(Resolution.values()[sel]);
                break;
            }
            case 2: 
            case 3: {
                if (!this.host.supports(Capability.NOTE_REPEAT_LENGTH)) break;
                int sel2 = Resolution.change(Resolution.getMatch(this.noteRepeat.getNoteLength()), index == 3);
                configuration.setNoteRepeatLength(Resolution.values()[sel2]);
                break;
            }
            case 4: {
                if (!this.host.supports(Capability.NOTE_REPEAT_LATCH)) break;
                this.noteRepeat.toggleLatchActive();
                break;
            }
            case 5: {
                if (!this.host.supports(Capability.NOTE_REPEAT_USE_PRESSURE_TO_VELOCITY)) break;
                this.noteRepeat.toggleUsePressure();
                break;
            }
            case 6: {
                if (!this.host.supports(Capability.NOTE_REPEAT_IS_FREE_RUNNING)) break;
                this.noteRepeat.toggleIsFreeRunning();
                break;
            }
            case 7: {
                if (!this.host.supports(Capability.NOTE_REPEAT_SWING)) break;
                this.noteRepeat.toggleShuffle();
                break;
            }
        }
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP || this.noteRepeat == null) {
            return;
        }
        if (index == 7 && this.host.supports(Capability.NOTE_REPEAT_SWING)) {
            IParameter grooveEnabled;
            grooveEnabled.setValue((grooveEnabled = this.model.getGroove().getParameter(GrooveParameterID.ENABLED)).getValue() == 0 ? this.model.getValueChanger().getUpperBound() : 0);
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        int index = this.isButtonRow(0, buttonID);
        if (index >= 0) {
            ColorManager colorManager = this.model.getColorManager();
            int offColor = colorManager.getColorIndex("BUTTON_COLOR_OFF");
            int onColor = colorManager.getColorIndex("BUTTON_COLOR_ON");
            int hiColor = colorManager.getColorIndex("BUTTON_COLOR_HI");
            switch (index) {
                default: {
                    return onColor;
                }
                case 2: {
                    return this.host.supports(Capability.NOTE_REPEAT_LENGTH) ? onColor : offColor;
                }
                case 3: {
                    return this.host.supports(Capability.NOTE_REPEAT_LENGTH) ? onColor : offColor;
                }
                case 4: {
                    if (this.host.supports(Capability.NOTE_REPEAT_LATCH)) {
                        return this.noteRepeat.isLatchActive() ? hiColor : onColor;
                    }
                    return offColor;
                }
                case 5: {
                    if (this.host.supports(Capability.NOTE_REPEAT_USE_PRESSURE_TO_VELOCITY)) {
                        return this.noteRepeat.usePressure() ? hiColor : onColor;
                    }
                    return offColor;
                }
                case 6: {
                    if (this.host.supports(Capability.NOTE_REPEAT_IS_FREE_RUNNING)) {
                        return !this.noteRepeat.isFreeRunning() ? hiColor : onColor;
                    }
                    return offColor;
                }
                case 7: 
            }
            if (this.host.supports(Capability.NOTE_REPEAT_SWING)) {
                return this.noteRepeat.isShuffle() ? hiColor : onColor;
            }
            return offColor;
        }
        index = this.isButtonRow(1, buttonID);
        if (index >= 0) {
            ColorManager colorManager = this.model.getColorManager();
            if (index < 7) {
                return colorManager.getColorIndex("BUTTON_COLOR_OFF");
            }
            return this.model.getGroove().getParameter(GrooveParameterID.ENABLED).getValue() > 0 ? colorManager.getColorIndex("BUTTON_COLOR_HI") : colorManager.getColorIndex("BUTTON_COLOR_ON");
        }
        return super.getButtonColor(buttonID);
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        String bottomMenu;
        display.setCell(0, 0, "Period:");
        int selPeriodIndex = this.getSelectedPeriodIndex();
        int pos = 0;
        for (Pair<String, Boolean> p : Push1Display.createMenuList(4, Resolution.getNames(), selPeriodIndex)) {
            display.setCell(pos, 1, (p.getValue() != false ? Push1Display.SELECT_ARROW : " ") + p.getKey());
            ++pos;
        }
        if (this.host.supports(Capability.NOTE_REPEAT_LENGTH)) {
            display.setCell(0, 2, "Length:");
            int selLengthIndex = this.getSelectedNoteLengthIndex();
            pos = 0;
            for (Pair pair : Push1Display.createMenuList(4, Resolution.getNames(), selLengthIndex)) {
                display.setCell(pos, 3, ((Boolean)pair.getValue() != false ? Push1Display.SELECT_ARROW : " ") + (String)pair.getKey());
                ++pos;
            }
        }
        if (this.host.supports(Capability.NOTE_REPEAT_LATCH)) {
            display.setCell(3, 4, " Latch");
        }
        int upperBound = this.model.getValueChanger().getUpperBound();
        if (this.host.supports(Capability.NOTE_REPEAT_MODE)) {
            bottomMenu = this.host.supports(Capability.NOTE_REPEAT_USE_PRESSURE_TO_VELOCITY) ? "Use Pressure" : "";
            ArpeggiatorMode arpeggiatorMode = this.noteRepeat.getMode();
            Object configuration = ((PushControlSurface)this.surface).getConfiguration();
            List<ArpeggiatorMode> arpeggiatorModes = configuration.getArpeggiatorModes();
            int modeIndex = configuration.lookupArpeggiatorModeIndex(arpeggiatorMode);
            int value = modeIndex * upperBound / (arpeggiatorModes.size() - 1);
            display.setCell(0, 5, "Mode");
            display.setCell(1, 5, StringUtils.optimizeName(arpeggiatorMode.getName(), 8));
            display.setCell(2, 5, value, Format.FORMAT_VALUE);
            display.setCell(3, 5, bottomMenu);
        }
        if (this.host.supports(Capability.NOTE_REPEAT_OCTAVES)) {
            bottomMenu = this.host.supports(Capability.NOTE_REPEAT_IS_FREE_RUNNING) ? "  Sync" : "";
            int n = this.noteRepeat.getOctaves();
            int value = n * upperBound / 8;
            display.setCell(0, 6, "Octaves");
            display.setCell(1, 6, Integer.toString(n));
            display.setCell(2, 6, value, Format.FORMAT_VALUE);
            display.setCell(3, 6, bottomMenu);
        }
        if (this.host.supports(Capability.NOTE_REPEAT_SWING)) {
            IParameter shuffleParam = this.model.getGroove().getParameter(GrooveParameterID.SHUFFLE_AMOUNT);
            display.setCell(0, 7, shuffleParam.getName(10));
            display.setCell(1, 7, shuffleParam.getDisplayedValue(8));
            display.setCell(2, 7, shuffleParam.getValue(), Format.FORMAT_VALUE);
            display.setCell(3, 7, "Shuffle");
        }
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        boolean isBottomMenuEnabled;
        String bottomMenu;
        if (this.noteRepeat == null) {
            return;
        }
        display.addOptionElement("Period", "", false, "", "", false, false);
        int selPeriodIndex = this.getSelectedPeriodIndex();
        display.addListElement(6, Resolution.getNames(), selPeriodIndex);
        if (this.host.supports(Capability.NOTE_REPEAT_LENGTH)) {
            display.addOptionElement("  Length", "", false, "", "", false, false);
            int selLengthIndex = this.getSelectedNoteLengthIndex();
            display.addListElement(6, Resolution.getNames(), selLengthIndex);
        } else {
            display.addEmptyElement();
            display.addEmptyElement();
        }
        if (this.host.supports(Capability.NOTE_REPEAT_LATCH)) {
            display.addOptionElement("", "", false, "", "Latch", this.noteRepeat.isLatchActive(), false);
        } else {
            display.addEmptyElement();
        }
        int upperBound = this.model.getValueChanger().getUpperBound();
        if (this.host.supports(Capability.NOTE_REPEAT_MODE)) {
            bottomMenu = this.host.supports(Capability.NOTE_REPEAT_USE_PRESSURE_TO_VELOCITY) ? "Use Pressure" : "";
            isBottomMenuEnabled = this.noteRepeat.usePressure();
            ArpeggiatorMode mode = this.noteRepeat.getMode();
            Object configuration = ((PushControlSurface)this.surface).getConfiguration();
            List<ArpeggiatorMode> arpeggiatorModes = configuration.getArpeggiatorModes();
            int modeIndex = configuration.lookupArpeggiatorModeIndex(mode);
            int value = modeIndex * upperBound / (arpeggiatorModes.size() - 1);
            display.addParameterElementWithPlainMenu("", false, bottomMenu, null, isBottomMenuEnabled, "Mode", value, StringUtils.optimizeName(mode.getName(), 8), this.isKnobTouched(5), -1);
        } else {
            display.addEmptyElement();
        }
        if (this.host.supports(Capability.NOTE_REPEAT_OCTAVES)) {
            bottomMenu = this.host.supports(Capability.NOTE_REPEAT_IS_FREE_RUNNING) ? "Sync" : "";
            isBottomMenuEnabled = !this.noteRepeat.isFreeRunning();
            int octaves = this.noteRepeat.getOctaves();
            int value = octaves * upperBound / 8;
            display.addParameterElementWithPlainMenu("", false, bottomMenu, null, isBottomMenuEnabled, "Octaves", value, Integer.toString(octaves), this.isKnobTouched(6), -1);
        } else {
            display.addEmptyElement();
        }
        if (this.host.supports(Capability.NOTE_REPEAT_SWING)) {
            IGroove groove = this.model.getGroove();
            IParameter shuffleParam = groove.getParameter(GrooveParameterID.SHUFFLE_AMOUNT);
            IParameter enabledParam = groove.getParameter(GrooveParameterID.ENABLED);
            int value = enabledParam.getValue();
            display.addParameterElementWithPlainMenu("Groove " + enabledParam.getDisplayedValue(8), value != 0, "Shuffle", null, this.noteRepeat.isShuffle(), shuffleParam.getName(10), shuffleParam.getValue(), shuffleParam.getDisplayedValue(8), this.isKnobTouched(7), -1);
        } else {
            display.addEmptyElement();
        }
    }

    private int getSelectedPeriodIndex() {
        return this.noteRepeat == null ? -1 : Resolution.getMatch(this.noteRepeat.getPeriod());
    }

    private int getSelectedNoteLengthIndex() {
        return this.noteRepeat == null ? -1 : Resolution.getMatch(this.noteRepeat.getNoteLength());
    }
}

