/*
 * Decompiled with CFR 0.152.
 */
package com.illposed.osc.argument.handler;

import com.illposed.osc.BytesReceiver;
import com.illposed.osc.OSCParseException;
import com.illposed.osc.OSCSerializeException;
import com.illposed.osc.argument.ArgumentHandler;
import com.illposed.osc.argument.handler.BlobArgumentHandler;
import java.nio.ByteBuffer;
import java.util.Map;

public class ByteArrayBlobArgumentHandler
implements ArgumentHandler<byte[]>,
Cloneable {
    public static final ArgumentHandler<byte[]> INSTANCE = new ByteArrayBlobArgumentHandler();

    protected ByteArrayBlobArgumentHandler() {
    }

    @Override
    public char getDefaultIdentifier() {
        return 'b';
    }

    @Override
    public Class<byte[]> getJavaClass() {
        return byte[].class;
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
    }

    @Override
    public boolean isMarkerOnly() {
        return false;
    }

    public ByteArrayBlobArgumentHandler clone() throws CloneNotSupportedException {
        return (ByteArrayBlobArgumentHandler)super.clone();
    }

    @Override
    public byte[] parse(ByteBuffer input) throws OSCParseException {
        ByteBuffer bufferValue = BlobArgumentHandler.INSTANCE.parse(input);
        byte[] value = new byte[bufferValue.remaining()];
        bufferValue.get(value);
        return value;
    }

    @Override
    public void serialize(BytesReceiver output, byte[] value) throws OSCSerializeException {
        ByteBuffer bufferValue = ByteBuffer.wrap(value).asReadOnlyBuffer();
        BlobArgumentHandler.INSTANCE.serialize(output, bufferValue);
    }
}

