/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.ui.widget;

import de.mossgrabers.reaper.ui.widget.Functions;
import de.mossgrabers.reaper.ui.widget.JComboBoxX;
import de.mossgrabers.reaper.ui.widget.JListX;
import de.mossgrabers.reaper.ui.widget.MaxLengthDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class BoxPanel
extends JPanel {
    private static final long serialVersionUID = 4048792364380336179L;
    public static final int GLUE = -1;
    public static final int NONE = 0;
    public static final int SMALL = 4;
    public static final int ICON_SPACE = 7;
    public static final int NORMAL = 12;
    public static final int LARGE = 17;
    protected boolean isVert;
    protected float fieldAlignment;

    public BoxPanel(int alignment, boolean addBorderSpace) {
        this(alignment, 0.0f, addBorderSpace);
    }

    public BoxPanel(int alignment, float fieldAlignment, boolean addBorderSpace) {
        this.fieldAlignment = fieldAlignment;
        this.isVert = alignment == 1;
        this.setLayout(new BoxLayout(this, alignment));
        if (addBorderSpace) {
            this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        }
    }

    public void sizeEqual() {
        this.sizeEqual(this.isVert);
    }

    public void sizeEqual(boolean isVert) {
        List<JComponent> children = this.getJComponents();
        Dimension max = BoxPanel.calcMaxDimension(children);
        for (JComponent comp : children) {
            Dimension dim = comp.getPreferredSize();
            if (isVert) {
                dim.width = max.width;
            } else {
                dim.height = max.height;
            }
            comp.setMinimumSize(dim);
            comp.setMaximumSize(dim);
            comp.setPreferredSize(dim);
        }
        this.invalidate();
    }

    public JPanel stickToTop() {
        return this.stickTo("North");
    }

    public JPanel stickToBottom() {
        return this.stickTo("North");
    }

    public JPanel stickToLeft() {
        return this.stickTo("West");
    }

    public JPanel stickToRight() {
        return this.stickTo("East");
    }

    protected JPanel stickTo(String where) {
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)this, where);
        return wrapper;
    }

    public void setAllEnabled(boolean enable) {
        Functions.enableComponent(this, enable);
    }

    public <E> JComboBoxX<E> createComboBox(String label, String mnemonic, int space, Collection<E> content) {
        return this.addComponent(new JComboBoxX<E>(content), label, mnemonic, null, space);
    }

    public <E> JListX<E> createListBox(String label, String mnemonic, int space, Collection<E> content) {
        return this.createListBox(label, mnemonic, space, new JListX<E>(content));
    }

    public <E> JListX<E> createListBox(String label, String mnemonic, int space, JListX<E> list) {
        return this.addComponent(list, label, mnemonic, null, space, true);
    }

    public JButton createButton(String label, String mnemonic, int space) {
        return (JButton)this.addButton(new JButton(), null, label, mnemonic, null, space);
    }

    public JButton createButton(Icon icon, int space) {
        return (JButton)this.addButton(new JButton(), icon, null, null, null, space);
    }

    public JButton createButton(Icon icon, String label, String mnemonic, int space) {
        return (JButton)this.addButton(new JButton(), icon, label, mnemonic, null, space);
    }

    public JButton createButton(Icon icon, String label, String mnemonic, String tooltip, int space) {
        return (JButton)this.addButton(new JButton(), icon, label, mnemonic, tooltip, space);
    }

    public JRadioButton createRadioButton(String label, String mnemonic, int space) {
        return this.createRadioButton(label, mnemonic, null, space);
    }

    public JRadioButton createRadioButton(String label, String mnemonic, String tooltip, int space) {
        return (JRadioButton)this.addButton(new JRadioButton(), null, label, mnemonic, tooltip, space);
    }

    public JCheckBox createCheckBox(String label, String mnemonic, int space) {
        return (JCheckBox)this.addButton(new JCheckBox(), null, label, mnemonic, null, space);
    }

    public JTextField createField(String label, String mnemonic, int space) {
        return this.createField(label, mnemonic, space, -1);
    }

    public JTextField createField(String label, String mnemonic, int space, int columns) {
        return this.createField(label, mnemonic, space, columns, -1);
    }

    public JTextField createField(String label, String mnemonic, int space, int columns, int maxChars) {
        JTextField field = this.addField(new JTextField(), label, mnemonic, space, columns);
        if (maxChars != -1) {
            field.setDocument(new MaxLengthDocument(maxChars));
        }
        return field;
    }

    public JPasswordField createPasswordField(String label, String mnemonic, int space, int columns) {
        return this.createPasswordField(label, mnemonic, space, columns, -1);
    }

    public JPasswordField createPasswordField(JLabel label, String mnemonic, int space, int columns) {
        return this.createPasswordField(label, mnemonic, space, columns, -1);
    }

    public JPasswordField createPasswordField(String label, String mnemonic, int space, int columns, int maxChars) {
        JPasswordField field = new JPasswordField();
        this.addField(field, label, mnemonic, space, columns);
        if (maxChars != -1) {
            field.setDocument(new MaxLengthDocument(maxChars));
        }
        return field;
    }

    public JPasswordField createPasswordField(JLabel label, String mnemonic, int space, int columns, int maxChars) {
        JPasswordField field = new JPasswordField();
        this.addField(field, label, mnemonic, space, columns);
        if (maxChars != -1) {
            field.setDocument(new MaxLengthDocument(maxChars));
        }
        return field;
    }

    public JTextArea createTextArea(String label, String mnemonic, int space) {
        return this.createTextArea(label, mnemonic, space, 0, 0);
    }

    public JTextArea createTextArea(String label, String mnemonic, int space, int rows, int columns) {
        return this.createTextArea(label, mnemonic, space, rows, columns, -1);
    }

    public JTextArea createTextArea(String label, String mnemonic, int space, int rows, int columns, int maxChars) {
        JTextArea area = this.addComponent(new JTextArea(rows, columns), label, mnemonic, null, space, true);
        if (maxChars != -1) {
            area.setDocument(new MaxLengthDocument(maxChars));
        }
        return area;
    }

    public JTextPane createTextPane(String label, String mnemonic, int space) {
        return this.createTextPane(label, mnemonic, space, 0);
    }

    public JTextPane createTextPane(String label, String mnemonic, int space, int rows) {
        JTextPane textPane = this.addComponent(new JTextPane(), label, mnemonic, null, space, true);
        if (rows > 0) {
            Dimension dim = textPane.getPreferredSize();
            dim.height = rows * textPane.getFontMetrics(textPane.getFont()).getHeight();
            Container scrollPane = textPane.getParent().getParent();
            scrollPane.setPreferredSize(dim);
            if (dim.width > 10) {
                dim.width = 10;
            }
            scrollPane.setMinimumSize(dim);
        }
        return textPane;
    }

    public JSeparator createSeparator(int space) {
        return this.addComponent(new JSeparator(this.isVert ? 0 : 1), (JLabel)null, null, null, space);
    }

    public JLabel createIcon(Icon icon, int space) {
        return this.addComponent(new JLabel(icon), (JLabel)null, null, null, space);
    }

    public JLabel createLabel(String label, String mnemonic, int space) {
        return this.addLabel(new JLabel(Functions.getText(label)), mnemonic, space);
    }

    public JLabel addLabel(JLabel label, String mnemonic, int space) {
        JLabel aLabel = this.addComponent(label, "", null, null, space, false);
        if (mnemonic != null) {
            aLabel.setDisplayedMnemonic(this.getMnemonicChar(mnemonic));
        }
        return aLabel;
    }

    public void createSpace(int space) {
        if (space == 0) {
            return;
        }
        if (space == -1) {
            this.add(this.isVert ? Box.createVerticalGlue() : Box.createHorizontalGlue());
        } else {
            this.add(Box.createRigidArea(new Dimension(this.isVert ? 0 : space, this.isVert ? space : 0)));
        }
    }

    public <T extends JComponent> T addComponent(T component, int space) {
        return this.addComponent(component, (JLabel)null, null, space);
    }

    public <T extends JComponent> T addComponent(T component, String label, String mnemonic, int space) {
        return this.addComponent(component, label, mnemonic, space, false);
    }

    public <T extends JComponent> T addComponent(T component, JLabel label, String mnemonic, int space) {
        return this.addComponent(component, label, mnemonic, space, false);
    }

    public <T extends JComponent> T addComponent(T component, String label, String mnemonic, String tooltip, int space) {
        return this.addComponent(component, label, mnemonic, tooltip, space, false);
    }

    public <T extends JComponent> T addComponent(T component, JLabel label, String mnemonic, String tooltip, int space) {
        return this.addComponent(component, label, mnemonic, tooltip, space, false);
    }

    public <T extends JComponent> T addComponent(T component, String label, String mnemonic, int space, boolean addScrollPane) {
        return this.addComponent(component, label, mnemonic, null, space, addScrollPane);
    }

    public <T extends JComponent> T addComponent(T component, JLabel label, String mnemonic, int space, boolean addScrollPane) {
        return this.addComponent(component, label, mnemonic, null, space, addScrollPane);
    }

    public <T extends JComponent> T addComponent(T component, String label, String mnemonic, String tooltip, int space, boolean addScrollPane) {
        JLabel l = label != null && label.length() > 0 ? new JLabel(Functions.getText(label)) : null;
        return this.addComponent(component, l, mnemonic, tooltip, space, addScrollPane);
    }

    public <T extends JComponent> T addComponent(T component, JLabel label, String mnemonic, String tooltip, int space, boolean addScrollPane) {
        if (label != null) {
            this.addLabel(label, mnemonic, 4).setLabelFor(component);
        }
        if (tooltip != null) {
            component.setToolTipText(Functions.getText(tooltip));
        }
        JScrollPane c = addScrollPane ? new JScrollPane(component) : component;
        this.add(c);
        if (this.isVert) {
            c.setAlignmentX(this.fieldAlignment);
        } else {
            c.setAlignmentY(this.fieldAlignment);
        }
        this.createSpace(space);
        return component;
    }

    protected AbstractButton addButton(AbstractButton button, Icon icon, String label, String mnemonic, String tooltip, int space) {
        if (icon != null) {
            button.setIcon(icon);
            button.setIconTextGap(7);
        }
        button.setText(Functions.getText(label));
        button.setMnemonic(this.getMnemonicChar(mnemonic));
        this.addComponent(button, (JLabel)null, null, tooltip, space);
        return button;
    }

    protected <T extends JTextField> T addField(T field, String label, String mnemonic, int space, int columns) {
        if (columns != -1) {
            field.setColumns(columns);
        }
        return this.addComponent(field, label, mnemonic, space);
    }

    protected JTextField addField(JTextField field, JLabel label, String mnemonic, int space, int columns) {
        if (columns != -1) {
            field.setColumns(columns);
        }
        return this.addComponent(field, label, mnemonic, space);
    }

    protected char getMnemonicChar(String text) {
        String t = Functions.getText(text);
        return t.length() == 0 ? (char)'\u0000' : t.charAt(0);
    }

    private static Dimension calcMaxDimension(List<JComponent> children) {
        Dimension max = new Dimension(0, 0);
        for (JComponent comp : children) {
            Dimension dim = comp.getMinimumSize();
            if (max.width < dim.width) {
                max.width = dim.width;
            }
            if (max.height >= dim.height) continue;
            max.height = dim.height;
        }
        return max;
    }

    private List<JComponent> getJComponents() {
        ArrayList<JComponent> swingComponents = new ArrayList<JComponent>();
        for (Component component : this.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            JComponent jc = (JComponent)component;
            if (component instanceof Box.Filler) continue;
            swingComponents.add(jc);
        }
        return swingComponents;
    }
}

