/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data.parameter;

import de.mossgrabers.framework.daw.GrooveParameterID;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.data.parameter.ParameterImpl;
import java.util.EnumMap;
import java.util.Map;

public class GrooveParameter
extends ParameterImpl {
    private static final Map<GrooveParameterID, String> NAMES = new EnumMap<GrooveParameterID, String>(GrooveParameterID.class);
    private final GrooveParameterID grooveParameterID;

    public GrooveParameter(DataSetupEx dataSetup, GrooveParameterID grooveParameterID) {
        super(dataSetup, grooveParameterID.ordinal(), 0.0);
        this.grooveParameterID = grooveParameterID;
        this.setExists(true);
        this.setInternalName(NAMES.get((Object)grooveParameterID));
    }

    @Override
    public String getDisplayedValue() {
        if (this.grooveParameterID == GrooveParameterID.ENABLED) {
            return Integer.toString((int)this.value);
        }
        return String.format("%.1f %%", (this.value * 2.0 - 1.0) * 100.0);
    }

    @Override
    public void setInternalValue(double value) {
        double v = this.grooveParameterID == GrooveParameterID.ENABLED ? (value > 0.0 ? 1.0 : 0.0) : (value + 1.0) / 2.0;
        super.setInternalValue(v);
    }

    @Override
    protected void sendValue() {
        if (this.grooveParameterID == GrooveParameterID.ENABLED) {
            this.sendOSC("active", this.value);
        } else {
            this.sendOSC("amount", this.value * 2.0 - 1.0);
        }
    }

    @Override
    protected Processor getProcessor() {
        return Processor.GROOVE;
    }

    @Override
    public void resetValue() {
        if (this.grooveParameterID == GrooveParameterID.ENABLED) {
            super.resetValue();
        } else {
            this.setNormalizedValue(0.5);
        }
    }

    static {
        NAMES.put(GrooveParameterID.ENABLED, "Enabled");
        NAMES.put(GrooveParameterID.SHUFFLE_AMOUNT, "Shuffle Amount");
    }
}

