/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data.parameter;

import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.data.EqualizerBandType;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.data.parameter.ParameterImpl;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class EqBandTypeParameterImpl
extends ParameterImpl {
    private static final String BAND = "band/";
    private static final Map<EqualizerBandType, Integer> EQ_TYPE_INDICES = new EnumMap<EqualizerBandType, Integer>(EqualizerBandType.class);
    private static final Map<Integer, EqualizerBandType> EQ_TYPE_INDICES_INV = new HashMap<Integer, EqualizerBandType>();
    private final int bandIndex;
    private EqualizerBandType bandType = EqualizerBandType.OFF;

    public EqBandTypeParameterImpl(DataSetupEx dataSetup, int bandIndex) {
        super(dataSetup, Processor.EQ, -1, 0.0);
        this.bandIndex = bandIndex;
    }

    public void setTypeInternal(Integer typeIndex) {
        EqualizerBandType type = EQ_TYPE_INDICES_INV.get(typeIndex);
        this.bandType = type == null ? EqualizerBandType.OFF : type;
    }

    public void setType(EqualizerBandType type) {
        this.dataSetup.getSender().processStringArg(Processor.EQ, BAND + this.bandIndex, EQ_TYPE_INDICES.get((Object)type).toString());
    }

    public EqualizerBandType getTypeInternal() {
        return this.bandType;
    }

    @Override
    public void setNormalizedValue(double value) {
        EqualizerBandType[] types = EqualizerBandType.values();
        int typeIndex = (int)Math.round(value * (double)(types.length - 1));
        this.setType(types[typeIndex]);
    }

    @Override
    public void setValue(IValueChanger valueChanger, int value) {
        this.setNormalizedValue(valueChanger.toNormalizedValue(value));
    }

    @Override
    public int getValue() {
        return (int)Math.round((double)this.bandType.ordinal() * (127.0 / (double)(EqualizerBandType.values().length - 1)));
    }

    @Override
    public void changeValue(IValueChanger valueChanger, int value) {
        this.inc(valueChanger.calcKnobChange(value) > 0.0 ? 1.0 : -1.0);
    }

    @Override
    public void resetValue() {
        this.sendOSC(BAND + this.index, -1);
    }

    @Override
    public void inc(double increment) {
        int idValue = Math.min(Math.max(0, (int)((double)this.bandType.ordinal() + increment)), 6);
        Integer id = EQ_TYPE_INDICES.get((Object)EqualizerBandType.values()[idValue]);
        this.sendOSC(BAND + this.bandIndex, id.toString());
    }

    @Override
    public String getDisplayedValue() {
        return "Band Type " + (this.bandIndex + 1);
    }

    static {
        EQ_TYPE_INDICES.put(EqualizerBandType.OFF, -1);
        EQ_TYPE_INDICES.put(EqualizerBandType.LOWCUT, 4);
        EQ_TYPE_INDICES.put(EqualizerBandType.LOWSHELF, 0);
        EQ_TYPE_INDICES.put(EqualizerBandType.BELL, 8);
        EQ_TYPE_INDICES.put(EqualizerBandType.HIGHCUT, 3);
        EQ_TYPE_INDICES.put(EqualizerBandType.HIGHSHELF, 1);
        EQ_TYPE_INDICES.put(EqualizerBandType.NOTCH, 6);
        EQ_TYPE_INDICES_INV.put(-1, EqualizerBandType.OFF);
        EQ_TYPE_INDICES_INV.put(4, EqualizerBandType.LOWCUT);
        EQ_TYPE_INDICES_INV.put(0, EqualizerBandType.LOWSHELF);
        EQ_TYPE_INDICES_INV.put(8, EqualizerBandType.BELL);
        EQ_TYPE_INDICES_INV.put(9, EqualizerBandType.BELL);
        EQ_TYPE_INDICES_INV.put(2, EqualizerBandType.BELL);
        EQ_TYPE_INDICES_INV.put(3, EqualizerBandType.HIGHCUT);
        EQ_TYPE_INDICES_INV.put(1, EqualizerBandType.HIGHSHELF);
        EQ_TYPE_INDICES_INV.put(6, EqualizerBandType.NOTCH);
        EQ_TYPE_INDICES_INV.put(5, EqualizerBandType.BELL);
        EQ_TYPE_INDICES_INV.put(7, EqualizerBandType.BELL);
    }
}

