/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data.bank;

import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.bank.ISlotBank;
import de.mossgrabers.framework.observer.IBankPageObserver;
import de.mossgrabers.framework.observer.IItemSelectionObserver;
import de.mossgrabers.reaper.framework.daw.data.bank.SlotBankImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ResizedSlotBank
implements ISlotBank {
    private static final Map<ISlotBank, SlotBankImpl> resizedBanks = new HashMap<ISlotBank, SlotBankImpl>();
    private final ICursorTrack cursorTrack;
    private final int differentPageSize;

    public ResizedSlotBank(ICursorTrack cursorTrack, int differentPageSize) {
        this.cursorTrack = cursorTrack;
        this.differentPageSize = differentPageSize;
    }

    @Override
    public int getPageSize() {
        return this.differentPageSize;
    }

    @Override
    public int getItemCount() {
        return this.getResizedBank().getItemCount();
    }

    @Override
    public boolean hasExistingItems() {
        return this.getResizedBank().hasExistingItems();
    }

    @Override
    public ISlot getItem(int index) {
        return (ISlot)this.getResizedBank().getItem(index);
    }

    @Override
    public Optional<ISlot> getSelectedItem() {
        return this.getResizedBank().getSelectedItem();
    }

    @Override
    public List<ISlot> getSelectedItems() {
        return this.getResizedBank().getSelectedItems();
    }

    @Override
    public void addSelectionObserver(IItemSelectionObserver observer) {
        this.getResizedBank().addSelectionObserver(observer);
    }

    @Override
    public void removeSelectionObserver(IItemSelectionObserver observer) {
        this.getResizedBank().removeSelectionObserver(observer);
    }

    @Override
    public void addPageObserver(IBankPageObserver observer) {
        this.getResizedBank().addPageObserver(observer);
    }

    @Override
    public void removePageObserver(IBankPageObserver observer) {
        this.getResizedBank().removePageObserver(observer);
    }

    @Override
    public boolean canScrollBackwards() {
        return this.getResizedBank().canScrollBackwards();
    }

    @Override
    public boolean canScrollForwards() {
        return this.getResizedBank().canScrollForwards();
    }

    @Override
    public boolean canScrollPageBackwards() {
        return this.getResizedBank().canScrollPageBackwards();
    }

    @Override
    public boolean canScrollPageForwards() {
        return this.getResizedBank().canScrollPageForwards();
    }

    @Override
    public void scrollBackwards() {
        this.getResizedBank().scrollBackwards();
    }

    @Override
    public void scrollForwards() {
        this.getResizedBank().scrollForwards();
    }

    @Override
    public void scrollTo(int position) {
        this.getResizedBank().scrollTo(position);
    }

    @Override
    public void scrollTo(int position, boolean adjustPage) {
        this.getResizedBank().scrollTo(position, adjustPage);
    }

    @Override
    public int getScrollPosition() {
        return this.getResizedBank().getScrollPosition();
    }

    @Override
    public int getPositionOfLastItem() {
        return this.getResizedBank().getPositionOfLastItem();
    }

    @Override
    public void selectItemAtPosition(int position) {
        this.getResizedBank().selectItemAtPosition(position);
    }

    @Override
    public void selectNextItem() {
        this.getResizedBank().selectNextItem();
    }

    @Override
    public void selectPreviousItem() {
        this.getResizedBank().selectPreviousItem();
    }

    @Override
    public void selectNextPage() {
        this.getResizedBank().selectNextPage();
    }

    @Override
    public void selectPreviousPage() {
        this.getResizedBank().selectPreviousPage();
    }

    @Override
    public void setSkipDisabledItems(boolean shouldSkip) {
        this.getResizedBank().setSkipDisabledItems(shouldSkip);
    }

    @Override
    public void enableObservers(boolean enable) {
        this.getResizedBank().enableObservers(enable);
    }

    @Override
    public Optional<ISlot> getEmptySlot(int startFrom) {
        return this.getResizedBank().getEmptySlot(startFrom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISlotBank getResizedBank() {
        ISlotBank cursorSlotBank = this.cursorTrack.getSlotBank();
        Map<ISlotBank, SlotBankImpl> map = resizedBanks;
        synchronized (map) {
            final SlotBankImpl slotBankImpl = (SlotBankImpl)cursorSlotBank;
            return resizedBanks.computeIfAbsent(cursorSlotBank, bank -> new SlotBankImpl(this, (SlotBankImpl)bank, this.differentPageSize){

                @Override
                public int getItemCount() {
                    return slotBankImpl.getItemCount();
                }
            });
        }
    }
}

