/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw;

import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.constants.AutomationMode;
import de.mossgrabers.framework.daw.constants.LaunchQuantization;
import de.mossgrabers.framework.daw.constants.PostRecordingAction;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.parameter.AutomationModeParameter;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.daw.BaseImpl;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;
import de.mossgrabers.reaper.framework.daw.data.MasterTrackImpl;
import de.mossgrabers.reaper.framework.daw.data.TrackImpl;
import de.mossgrabers.reaper.framework.daw.data.parameter.MetronomeVolumeParameterImpl;
import de.mossgrabers.reaper.framework.daw.data.parameter.TempoParameterImpl;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

public class TransportImpl
extends BaseImpl
implements ITransport {
    private static final Map<Double, Double> ZOOM_RESOLUTIONS = new TreeMap<Double, Double>();
    private static final int PUNCH_OFF = 0;
    private static final int PUNCH_ITEMS = 1;
    private static final int PUNCH_LOOP = 2;
    private static final Object UPDATE_LOCK;
    private final IModel model;
    private double position = 0.0;
    private String positionStr = "";
    private String beatsStr = "";
    private double loopStart = 0.0;
    private double loopLength = 0.0;
    private String loopStartBeatsStr = "";
    private String loopLengthBeatsStr = "";
    private String loopStartStr = "";
    private String loopLengthStr = "";
    private boolean isMetronomeOn = false;
    private boolean isPlaying = false;
    private boolean isRecording = false;
    private boolean isLooping = false;
    private int numerator = 4;
    private int denominator = 4;
    private boolean prerollMetronome = false;
    private int prerollMeasures = 2;
    private int punchMode = 0;
    private final MetronomeVolumeParameterImpl metronomeVolumeParameter;
    private final TempoParameterImpl tempoParameter;
    private final AutomationModeParameter automationParameter;
    private AutomationMode automationMode = AutomationMode.TRIM_READ;
    private double visiblePixelsPerSecond;

    public TransportImpl(DataSetupEx dataSetup, IModel model) {
        super(dataSetup);
        this.model = model;
        this.metronomeVolumeParameter = new MetronomeVolumeParameterImpl(dataSetup);
        this.tempoParameter = new TempoParameterImpl(dataSetup);
        this.automationParameter = new AutomationModeParameter(this.valueChanger, this);
    }

    @Override
    public void enableObservers(boolean enable) {
        this.sender.enableUpdates(Processor.TRANSPORT, enable);
    }

    @Override
    public void play() {
        if (this.isPlaying && this.isRecording) {
            this.sender.processNoArg(Processor.RECORD);
        }
        this.sender.processNoArg(Processor.PLAY);
    }

    @Override
    public boolean isPlaying() {
        return this.isPlaying;
    }

    @Override
    public void restart() {
        if (this.isPlaying) {
            this.stop();
        }
        this.play();
    }

    @Override
    public void stop() {
        if (this.isPlaying && this.isRecording) {
            this.sender.processNoArg(Processor.RECORD);
        }
        this.sender.processNoArg(Processor.STOP);
    }

    @Override
    public void stopAndRewind() {
        this.stop();
        this.sender.processIntArg(Processor.TIME, 0);
    }

    @Override
    public void startRecording() {
        this.sender.processNoArg(Processor.RECORD);
    }

    @Override
    public boolean isRecording() {
        return this.isRecording;
    }

    @Override
    public boolean isArrangerOverdub() {
        return this.isLauncherOverdub();
    }

    @Override
    public void toggleOverdub() {
        this.toggleLauncherOverdub();
    }

    @Override
    public boolean isLauncherOverdub() {
        TrackImpl trackImpl;
        Object t;
        Optional selectedTrackOpt = this.model.getCurrentTrackBank().getSelectedItem();
        return selectedTrackOpt.isPresent() && (t = selectedTrackOpt.get()) instanceof TrackImpl && (trackImpl = (TrackImpl)t).isOverdub();
    }

    @Override
    public void setLauncherOverdub(boolean on) {
        Optional selectedTrackOpt = this.model.getCurrentTrackBank().getSelectedItem();
        if (!selectedTrackOpt.isEmpty()) {
            this.sender.processBooleanArg(Processor.TRACK, ((ITrack)selectedTrackOpt.get()).getPosition() + "/overdub", on);
        }
    }

    @Override
    public void toggleLauncherOverdub() {
        this.setLauncherOverdub(!this.isLauncherOverdub());
    }

    public void setMetronomeState(boolean on) {
        this.isMetronomeOn = on;
    }

    @Override
    public void setMetronome(boolean on) {
        this.invokeAction(on ? 41745 : 41746);
    }

    @Override
    public boolean isMetronomeOn() {
        return this.isMetronomeOn;
    }

    @Override
    public void toggleMetronome() {
        this.invokeAction(40364);
    }

    @Override
    public boolean isMetronomeTicksOn() {
        return false;
    }

    @Override
    public void toggleMetronomeTicks() {
    }

    @Override
    public void setMetronomeTicks(boolean on) {
    }

    @Override
    public IParameter getMetronomeVolumeParameter() {
        return this.metronomeVolumeParameter;
    }

    @Override
    public String getMetronomeVolumeStr() {
        return this.metronomeVolumeParameter.getDisplayedValue();
    }

    @Override
    public void changeMetronomeVolume(int control) {
        this.metronomeVolumeParameter.inc(this.valueChanger.isIncrease(control) ? 1.0 : -1.0);
    }

    @Override
    public void setMetronomeVolume(int value) {
        this.metronomeVolumeParameter.setValue(value);
    }

    public void setInternalMetronomeVolume(double metronomeVolume) {
        this.metronomeVolumeParameter.setInternalMetronomeVolume(metronomeVolume);
    }

    @Override
    public int getMetronomeVolume() {
        return this.metronomeVolumeParameter.getValue();
    }

    @Override
    public boolean isPrerollMetronomeEnabled() {
        return this.prerollMetronome;
    }

    @Override
    public void togglePrerollMetronome() {
        this.invokeAction(41819);
    }

    public void setPrerollMetronomeInternal(boolean enable) {
        this.prerollMetronome = enable;
    }

    @Override
    public int getPrerollMeasures() {
        return this.prerollMeasures;
    }

    @Override
    public void setPrerollMeasures(int measures) {
        this.prerollMeasures = measures;
        this.sender.processIntArg(Processor.INIFILE, "reaper/prerollmeas", measures);
    }

    public void setPrerollMeasuresInternal(int measures) {
        this.prerollMeasures = measures;
        if (this.prerollMeasures < 0 || this.prerollMeasures > 4) {
            this.prerollMeasures = 2;
        }
    }

    @Override
    public void setLoop(boolean on) {
        if (on && !this.isLooping || !on && this.isLooping) {
            this.sender.processIntArg(Processor.REPEAT, 1);
        }
    }

    @Override
    public void toggleLoop() {
        this.sender.processIntArg(Processor.REPEAT, 1);
    }

    @Override
    public boolean isLoop() {
        return this.isLooping;
    }

    @Override
    public boolean isWritingClipLauncherAutomation() {
        return false;
    }

    @Override
    public boolean isWritingArrangerAutomation() {
        AutomationMode automationWriteMode = this.getAutomationWriteMode();
        return automationWriteMode != AutomationMode.READ && automationWriteMode != AutomationMode.TRIM_READ;
    }

    @Override
    public IParameter getAutomationModeParameter() {
        return this.automationParameter;
    }

    @Override
    public AutomationMode[] getAutomationWriteModes() {
        return AutomationMode.values();
    }

    @Override
    public AutomationMode getAutomationWriteMode() {
        return this.automationMode;
    }

    public void setAutomationWriteModeState(AutomationMode mode) {
        this.automationMode = mode;
    }

    @Override
    public void setAutomationWriteMode(AutomationMode mode) {
        this.sender.processIntArg(Processor.AUTOMATION, switch (mode) {
            default -> 0;
            case AutomationMode.READ -> 1;
            case AutomationMode.TOUCH -> 2;
            case AutomationMode.WRITE -> 3;
            case AutomationMode.LATCH -> 4;
            case AutomationMode.LATCH_PREVIEW -> 5;
        });
    }

    @Override
    public void toggleWriteArrangerAutomation() {
        if (this.isWritingArrangerAutomation()) {
            this.setAutomationWriteMode(AutomationMode.TRIM_READ);
        } else {
            this.setAutomationWriteMode(AutomationMode.WRITE);
        }
    }

    @Override
    public void toggleWriteClipLauncherAutomation() {
    }

    @Override
    public void resetAutomationOverrides() {
    }

    @Override
    public void returnToArrangement() {
    }

    @Override
    public String getPositionText() {
        return this.positionStr;
    }

    @Override
    public String getBeatText() {
        return this.beatsStr;
    }

    public void setPositionText(String positionStr) {
        this.positionStr = TransportImpl.reformatTime(positionStr);
    }

    public void setBeats(String beats) {
        this.beatsStr = TransportImpl.reformatBeats(beats, 1);
    }

    public void setPositionValue(double time) {
        this.position = time;
    }

    @Override
    public void setPosition(double time) {
        this.setPosition(time, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPosition(double time, boolean snap) {
        Object object = UPDATE_LOCK;
        synchronized (object) {
            if (this.isAutomationRecActive()) {
                this.sender.delayUpdates(Processor.TRANSPORT);
            }
            this.position = time;
            if (snap) {
                this.sender.processDoubleArg(Processor.TIME, this.position);
            } else {
                this.sender.processDoubleArg(Processor.TIME, "nosnap", this.position);
            }
        }
    }

    @Override
    public double getPosition() {
        return this.position;
    }

    @Override
    public void setPositionToEnd() {
        this.invokeAction(40043);
    }

    @Override
    public void changePosition(boolean increase, boolean slow) {
        double resolution = this.getZoomResolution();
        double fraction = this.calcScrollFraction(resolution, slow);
        double pos = (double)Math.round(this.secondsToBeats(this.position) / fraction) * fraction;
        double beats = increase ? pos + fraction : Math.max(pos - fraction, 0.0);
        this.setPosition(this.beatsToSeconds(beats), !slow);
    }

    private double calcScrollFraction(double resolution, boolean slow) {
        return slow ? resolution : resolution * (double)this.getQuartersPerMeasure() * 4.0;
    }

    private double beatsToSeconds(double beats) {
        return beats * 60.0 / this.getTempo();
    }

    private double secondsToBeats(double seconds) {
        return seconds * this.getTempo() / 60.0;
    }

    public void setLoopStartValue(double time) {
        this.loopStart = time;
    }

    public void setLoopStartText(String time) {
        this.loopStartStr = TransportImpl.reformatTime(time);
    }

    @Override
    public double getLoopStart() {
        return this.loopStart;
    }

    @Override
    public double getLoopEnd() {
        return this.loopStart + this.loopLength;
    }

    public String getLoopStartStr() {
        return this.loopStartStr;
    }

    public void setLoopStartBeatText(String beats) {
        this.loopStartBeatsStr = TransportImpl.reformatBeats(beats, 1);
    }

    @Override
    public String getLoopStartBeatText() {
        return this.loopStartBeatsStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoopStart(double time) {
        Object object = UPDATE_LOCK;
        synchronized (object) {
            if (this.isAutomationRecActive()) {
                this.sender.delayUpdates(Processor.TRANSPORT);
            }
            this.loopStart = time;
            this.sender.processDoubleArg(Processor.TIME, "loop/start", this.loopStart);
        }
    }

    @Override
    public void changeLoopStart(boolean increase, boolean slow) {
        double frac = this.beatsToSeconds(slow ? 1.0 : 4.0);
        this.setLoopStart(increase ? this.loopStart + frac : Math.max(this.loopStart - frac, 0.0));
    }

    @Override
    public void selectLoopStart() {
        this.setPosition(this.loopStart);
    }

    @Override
    public void selectLoopEnd() {
        this.setPosition(this.loopLength);
    }

    public void setLoopLengthText(String time) {
        this.loopLengthStr = TransportImpl.reformatTime(time);
    }

    public String getLoopLengthStr() {
        return this.loopLengthStr;
    }

    public void setLoopLengthValue(double time) {
        this.loopLength = time;
    }

    public void setLoopLengthBeatText(String beats) {
        this.loopLengthBeatsStr = TransportImpl.reformatBeats(beats, 0);
    }

    @Override
    public String getLoopLengthBeatText() {
        return this.loopLengthBeatsStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoopLength(double time) {
        Object object = UPDATE_LOCK;
        synchronized (object) {
            if (this.isAutomationRecActive()) {
                this.sender.delayUpdates(Processor.TRANSPORT);
            }
            this.loopLength = time;
            this.sender.processDoubleArg(Processor.TIME, "loop/length", this.loopLength);
        }
    }

    @Override
    public void changeLoopLength(boolean increase, boolean slow) {
        double frac = this.beatsToSeconds(slow ? 1.0 : 4.0);
        this.setLoopLength(increase ? this.loopLength + frac : Math.max(this.loopLength - frac, 0.0));
    }

    @Override
    public void togglePunchIn() {
        this.setPunchIn(!this.isPunchInEnabled());
    }

    @Override
    public void setPunchIn(boolean enable) {
        if (enable) {
            this.invokeAction(40076);
            this.punchMode = 2;
        } else {
            this.invokeAction(40252);
            this.punchMode = 0;
        }
    }

    @Override
    public boolean isPunchInEnabled() {
        return this.punchMode != 0;
    }

    @Override
    public void togglePunchOut() {
        this.setPunchOut(!this.isPunchOutEnabled());
    }

    @Override
    public void setPunchOut(boolean enable) {
        if (enable) {
            this.invokeAction(40253);
            this.punchMode = 1;
        } else {
            this.invokeAction(40252);
            this.punchMode = 0;
        }
    }

    @Override
    public boolean isPunchOutEnabled() {
        return this.punchMode != 0;
    }

    @Override
    public void tapTempo() {
        this.invokeAction(1134);
    }

    @Override
    public void changeTempo(boolean increase, boolean slow) {
        String dir = increase ? (slow ? "+" : "++") : (slow ? "-" : "--");
        this.sender.processNoArg(Processor.TEMPO, dir);
    }

    public TempoParameterImpl getTempoParameter() {
        return this.tempoParameter;
    }

    @Override
    public void setTempo(double tempo) {
        this.sender.processDoubleArg(Processor.TEMPO, tempo);
    }

    @Override
    public double getTempo() {
        return this.tempoParameter.getInternalValue();
    }

    @Override
    public double getMinimumTempo() {
        return 2.0;
    }

    @Override
    public double getMaximumTempo() {
        return 960.0;
    }

    @Override
    public String formatTempo(double tempo) {
        return new DecimalFormat("#.00").format(tempo);
    }

    @Override
    public String formatTempoNoFraction(double tempo) {
        return new DecimalFormat("###").format(tempo);
    }

    @Override
    public void setTempoIndication(boolean isTouched) {
    }

    @Override
    public IParameter getCrossfadeParameter() {
        return ((MasterTrackImpl)this.model.getMasterTrack()).getCrossfaderParameter();
    }

    @Override
    public void setCrossfade(int value) {
        this.getCrossfadeParameter().setValue(value);
    }

    @Override
    public int getCrossfade() {
        IParameter crossfaderParameter = this.getCrossfadeParameter();
        if (crossfaderParameter.doesExist()) {
            return crossfaderParameter.getValue();
        }
        return this.valueChanger.getUpperBound() / 2;
    }

    @Override
    public void changeCrossfade(int control) {
        ((MasterTrackImpl)this.model.getMasterTrack()).getCrossfaderParameter().changeValue(control);
    }

    @Override
    public int getNumerator() {
        return this.numerator;
    }

    @Override
    public int getDenominator() {
        return this.denominator;
    }

    @Override
    public int getQuartersPerMeasure() {
        return 4 * this.getNumerator() / this.getDenominator();
    }

    public void setPlayState(boolean isPlaying) {
        this.isPlaying = isPlaying;
    }

    public void setRecordState(boolean isRecording) {
        this.isRecording = isRecording;
    }

    public void setLoopingState(boolean isLooping) {
        this.isLooping = isLooping;
    }

    public void setNumerator(int numerator) {
        this.numerator = numerator;
    }

    public void setDenominator(int denominator) {
        this.denominator = denominator;
    }

    @Override
    public double scaleTempo(double tempo, int maxValue) {
        double v = tempo - 20.0;
        return v * (double)(maxValue - 1) / 646.0;
    }

    @Override
    protected Processor getProcessor() {
        return Processor.TRANSPORT;
    }

    @Override
    public PostRecordingAction getClipLauncherPostRecordingAction() {
        return PostRecordingAction.OFF;
    }

    @Override
    public void setClipLauncherPostRecordingAction(PostRecordingAction action) {
    }

    @Override
    public double getClipLauncherPostRecordingTimeOffset() {
        return 0.0;
    }

    @Override
    public void setClipLauncherPostRecordingTimeOffset(double beats) {
    }

    @Override
    public LaunchQuantization getDefaultLaunchQuantization() {
        return LaunchQuantization.RES_NONE;
    }

    @Override
    public void setDefaultLaunchQuantization(LaunchQuantization launchQuantization) {
    }

    @Override
    public boolean isFillModeActive() {
        return false;
    }

    @Override
    public void setFillModeActive(boolean isActive) {
    }

    @Override
    public void toggleFillModeActive() {
    }

    private static String reformatBeats(String beatsStr, int offset) {
        int pos = beatsStr.lastIndexOf(46);
        if (pos < 1) {
            return "0:00";
        }
        String ticksStr = beatsStr.substring(pos + 1);
        int ticks = Integer.parseInt(ticksStr);
        int scaled = (int)Math.round((double)ticks * 399.0 / 99.0);
        int subBeats = scaled / 100;
        ticks = scaled % 100;
        return String.format("%s.%d:%02d", beatsStr.substring(0, pos), subBeats + offset, ticks);
    }

    private static String reformatTime(String timeStr) {
        String[] split = timeStr.split("\\.");
        if (split.length == 0) {
            return "0:000";
        }
        String replace = split[0].replace(':', '.');
        if (split.length == 1) {
            return replace;
        }
        return replace + ":" + split[1];
    }

    public void setHZoom(double visiblePixelsPerSecond) {
        this.visiblePixelsPerSecond = visiblePixelsPerSecond;
    }

    private double getZoomResolution() {
        double inverseContentPerPixel = this.visiblePixelsPerSecond;
        for (Map.Entry<Double, Double> entry : ZOOM_RESOLUTIONS.entrySet()) {
            if (!(inverseContentPerPixel < entry.getKey())) continue;
            return entry.getValue();
        }
        return 800000.0;
    }

    static {
        ZOOM_RESOLUTIONS.put(8.8, 1.0);
        ZOOM_RESOLUTIONS.put(27.94, 0.25);
        ZOOM_RESOLUTIONS.put(279.11, 0.0625);
        ZOOM_RESOLUTIONS.put(661.61, 0.03125);
        ZOOM_RESOLUTIONS.put(1176.2, 0.015625);
        ZOOM_RESOLUTIONS.put(2091.03, 0.0078125);
        ZOOM_RESOLUTIONS.put(4956.52, 0.00390625);
        ZOOM_RESOLUTIONS.put(8811.59, 0.001953125);
        ZOOM_RESOLUTIONS.put(20886.75, 9.765625E-4);
        ZOOM_RESOLUTIONS.put(37132.0, 4.8828125E-4);
        ZOOM_RESOLUTIONS.put(66012.45, 2.44140625E-4);
        ZOOM_RESOLUTIONS.put(156473.96, 1.220703125E-4);
        ZOOM_RESOLUTIONS.put(278175.93, 6.103515625E-5);
        ZOOM_RESOLUTIONS.put(600000.0, 3.0517578125E-5);
        ZOOM_RESOLUTIONS.put(800000.0, 1.52587890625E-5);
        UPDATE_LOCK = new Object();
    }
}

