/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.view;

import de.mossgrabers.controller.ableton.push.mode.device.DeviceLayerDetailsMode;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.grid.IPadGrid;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.ILayer;
import de.mossgrabers.framework.daw.data.IMasterTrack;
import de.mossgrabers.framework.daw.data.bank.IBank;
import de.mossgrabers.framework.featuregroup.AbstractView;
import de.mossgrabers.framework.featuregroup.IMode;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.view.ColorSelectMode;
import java.util.Optional;

public class ColorView<S extends IControlSurface<C>, C extends Configuration>
extends AbstractView<S, C> {
    private final int pageSize;
    private final int pages;
    private int page = 0;
    private ColorSelectMode mode = ColorSelectMode.MODE_TRACK;

    public ColorView(S surface, IModel model) {
        super("Color", surface, model);
        IPadGrid padGrid = this.surface.getPadGrid();
        this.pageSize = padGrid.getCols() * padGrid.getRows();
        DAWColor[] dawColors = DAWColor.values();
        this.pages = 1 + (dawColors.length - 1) / this.pageSize;
    }

    public void setMode(ColorSelectMode mode) {
        this.mode = mode;
    }

    public void setPage(int page) {
        this.page = Math.max(0, Math.min(page, this.pages - 1));
    }

    public int getPage() {
        return this.page;
    }

    @Override
    public void drawGrid() {
        IPadGrid padGrid = this.surface.getPadGrid();
        DAWColor[] dawColors = DAWColor.values();
        int offset = this.page * this.pageSize;
        for (int i = 0; i < this.pageSize; ++i) {
            int index = offset + i;
            padGrid.light(36 + i, index < dawColors.length ? dawColors[index].name() : "GRID_COLOR_OFF");
        }
    }

    @Override
    public void onGridNote(int note, int velocity) {
        if (velocity > 0) {
            return;
        }
        int offset = this.page * this.pageSize;
        int color = offset + note - 36;
        DAWColor[] dawColors = DAWColor.values();
        if (color < dawColors.length) {
            ColorEx entry = dawColors[color].getColor();
            switch (this.mode) {
                case MODE_TRACK: {
                    ICursorTrack cursorTrack = this.model.getCursorTrack();
                    if (cursorTrack.doesExist()) {
                        cursorTrack.setColor(entry);
                        break;
                    }
                    IMasterTrack master = this.model.getMasterTrack();
                    if (!master.isSelected()) break;
                    master.setColor(entry);
                    break;
                }
                case MODE_LAYER: {
                    IBank<ILayer> layerBank = this.getLayerBank();
                    Optional<ILayer> selectedItem = layerBank.getSelectedItem();
                    if (!selectedItem.isPresent()) break;
                    selectedItem.get().setColor(entry);
                    break;
                }
                case MODE_CLIP: {
                    INoteClip clip = this.model.getCursorClip();
                    if (!clip.doesExist()) break;
                    clip.setColor(entry);
                }
            }
        }
        this.surface.getViewManager().restore();
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        return "BUTTON_COLOR_OFF";
    }

    private IBank<? extends ILayer> getLayerBank() {
        IMode mode = (IMode)this.surface.getModeManager().get(Modes.DEVICE_LAYER_DETAILS);
        return ((DeviceLayerDetailsMode)mode).getBank();
    }
}

