/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.parameter;

import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.parameter.AbstractParameterImpl;

public class TempoParameter
extends AbstractParameterImpl {
    protected final ITransport transport;
    protected final IControlSurface<?> surface;

    public TempoParameter(IValueChanger valueChanger, ITransport transport, IControlSurface<?> surface) {
        super(valueChanger, 0);
        this.transport = transport;
        this.surface = surface;
    }

    @Override
    public int getValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setValue(IValueChanger valueChanger, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNormalizedValue(double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void changeValue(IValueChanger valueChanger, int value) {
        this.transport.changeTempo(valueChanger.isIncrease(value), this.surface.isKnobSensitivitySlow());
    }

    @Override
    public void setValueImmediatly(int value) {
        this.setValue(value);
    }

    @Override
    public void inc(double increment) {
        this.transport.changeTempo(increment > 0.0, this.surface.isKnobSensitivitySlow());
    }

    @Override
    public void resetValue() {
        this.transport.setTempo(120.0);
    }

    @Override
    public String getDisplayedValue() {
        return this.transport.formatTempo(this.transport.getTempo());
    }

    @Override
    public boolean doesExist() {
        return true;
    }

    @Override
    public String getName() {
        return "Tempo";
    }
}

