/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.graphics.canvas.component.simple;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.graphics.IGraphicsConfiguration;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.framework.graphics.IGraphicsInfo;
import de.mossgrabers.framework.graphics.canvas.component.simple.AbstractBaseComponent;

public class TitleValueComponent
extends AbstractBaseComponent {
    private final String label2;
    private final int value;
    private final int vuLeft;
    private final int vuRight;
    private final boolean isPan;
    protected int rowHeight = 20;

    public TitleValueComponent(String label1, String label2, int value, boolean isPan) {
        this(label1, label2, value, -1, -1, isPan);
    }

    public TitleValueComponent(String label1, String label2, int value, int vuLeft, int vuRight, boolean isPan) {
        super(label1);
        this.label2 = label2;
        this.value = value;
        this.vuLeft = vuLeft;
        this.vuRight = vuRight;
        this.isPan = isPan;
    }

    @Override
    public void draw(IGraphicsInfo info) {
        IGraphicsConfiguration configuration = info.getConfiguration();
        ColorEx colorText = configuration.getColorText();
        ColorEx colorFader = configuration.getColorFader();
        IGraphicsContext gc = info.getContext();
        this.draw(gc, 44.0, this.rowHeight, colorText, colorFader);
    }

    protected void draw(IGraphicsContext gc, double faderTop, double faderHeight, ColorEx colorText, ColorEx colorFader) {
        this.drawLabels(gc, colorText);
        this.drawFader(gc, colorFader, faderTop, faderHeight);
        this.drawVU(gc, colorFader);
    }

    protected void drawLabels(IGraphicsContext gc, ColorEx colorText) {
        gc.drawTextInHeight(this.label, 0.0, 0.0, this.rowHeight, colorText, this.rowHeight);
        gc.drawTextInHeight(this.label2, 0.0, this.rowHeight, this.rowHeight, colorText, this.rowHeight);
    }

    protected void drawFader(IGraphicsContext gc, ColorEx colorFader, double faderTop, double faderHeight) {
        if (this.value < 0) {
            return;
        }
        int width = this.value * 128 / 1024;
        gc.strokeRectangle(1.0, faderTop, 127.0, faderHeight, colorFader);
        if (this.isPan) {
            if (width == 64) {
                gc.fillRectangle(65.0, faderTop, 1.0, faderHeight, colorFader);
            } else if (width > 64) {
                gc.fillRectangle(65.0, faderTop, (double)width - 64.0, faderHeight, colorFader);
            } else {
                gc.fillRectangle(width, faderTop, 64.0 - (double)width, faderHeight, colorFader);
            }
        } else {
            gc.fillRectangle(1.0, faderTop, width, faderHeight, colorFader);
        }
    }

    protected void drawVU(IGraphicsContext gc, ColorEx color) {
        if (this.vuLeft <= 0 && this.vuRight <= 0) {
            return;
        }
        double height = 2.0 * (double)this.rowHeight;
        double heightLeft = (double)this.vuLeft * height / 1024.0;
        double topLeft = Math.max(height - heightLeft - 1.0, 0.0);
        gc.strokeRectangle(118.0, topLeft, 5.0, heightLeft, ColorEx.BLACK);
        gc.fillRectangle(119.0, height - heightLeft, 3.0, heightLeft, color);
        double heightRight = (double)this.vuRight * height / 1024.0;
        double topRight = Math.max(height - heightRight - 1.0, 0.0);
        gc.strokeRectangle(123.0, topRight, 4.0, height - topRight, ColorEx.BLACK);
        gc.fillRectangle(124.0, height - heightRight, 3.0, heightRight, color);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isPan ? 1231 : 1237);
        result = 31 * result + (this.label2 == null ? 0 : this.label2.hashCode());
        result = 31 * result + this.value;
        result = 31 * result + this.vuLeft;
        return 31 * result + this.vuRight;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        TitleValueComponent other = (TitleValueComponent)obj;
        if (this.isPan != other.isPan) {
            return false;
        }
        if (this.label2 == null ? other.label2 != null : !this.label2.equals(other.label2)) {
            return false;
        }
        if (this.value != other.value || this.vuLeft != other.vuLeft) {
            return false;
        }
        return this.vuRight == other.vuRight;
    }
}

