/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.graphics.canvas.component.simple;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.graphics.IGraphicsConfiguration;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.framework.graphics.IGraphicsInfo;
import de.mossgrabers.framework.graphics.canvas.component.simple.AbstractBaseComponent;
import java.util.Arrays;

public class TitleChannelsComponent
extends AbstractBaseComponent {
    private final boolean[] selected;
    private final int[] values;
    private final boolean isPan;
    protected int rowHeight = 20;

    public TitleChannelsComponent(String label, boolean[] selected, int[] values, boolean isPan) {
        super(label);
        this.selected = selected;
        this.values = values;
        this.isPan = isPan;
    }

    @Override
    public void draw(IGraphicsInfo info) {
        IGraphicsContext gc = info.getContext();
        IGraphicsConfiguration configuration = info.getConfiguration();
        ColorEx colorText = configuration.getColorText();
        ColorEx colorFader = configuration.getColorFader();
        gc.drawTextInHeight(this.label, 0.0, 0.0, this.rowHeight, colorText, this.rowHeight);
        int channelWidth = 128 / this.values.length;
        int halfChannelWidth = channelWidth / 2;
        int lowerHeight = 64 - this.rowHeight - 1;
        for (int i = 0; i < this.values.length; ++i) {
            int left = i * channelWidth;
            int faderHeight = this.values[i] * lowerHeight / 1024;
            if (this.isPan) {
                int center = lowerHeight / 2;
                if (this.selected[i]) {
                    if (faderHeight == center) {
                        gc.fillRectangle(left, (double)(64 - center) + 1.0, (double)halfChannelWidth + 1.0, 1.0, colorFader);
                        continue;
                    }
                    if (faderHeight > center) {
                        gc.fillRectangle(left, 64.0 - (double)center, (double)halfChannelWidth + 1.0, (double)faderHeight - (double)center, colorFader);
                        continue;
                    }
                    gc.fillRectangle(left, (double)(64 - lowerHeight) + (double)faderHeight, (double)halfChannelWidth + 1.0, (double)(center - faderHeight) + 2.0, colorFader);
                    continue;
                }
                if (faderHeight == center) {
                    gc.strokeRectangle((double)left + 1.0, (double)(64 - center) + 1.0, halfChannelWidth, 1.0, colorFader);
                    continue;
                }
                if (faderHeight > center) {
                    gc.strokeRectangle((double)left + 1.0, 64.0 - (double)center, halfChannelWidth, (double)faderHeight - (double)center, colorFader);
                    continue;
                }
                gc.strokeRectangle((double)left + 1.0, (double)(64 - lowerHeight) + (double)faderHeight, halfChannelWidth, (double)(center - faderHeight) + 2.0, colorFader);
                continue;
            }
            if (this.selected[i]) {
                gc.fillRectangle(left, 64.0 - (double)faderHeight, (double)halfChannelWidth + 1.0, faderHeight, colorFader);
                continue;
            }
            gc.strokeRectangle((double)left + 1.0, 64.0 - (double)faderHeight, halfChannelWidth, faderHeight, colorFader);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isPan ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.selected);
        return 31 * result + Arrays.hashCode(this.values);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        TitleChannelsComponent other = (TitleChannelsComponent)obj;
        if (this.isPan != other.isPan || !Arrays.equals(this.selected, other.selected)) {
            return false;
        }
        return Arrays.equals(this.values, other.values);
    }
}

