/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.graphics.canvas.component;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.graphics.IGraphicsConfiguration;
import de.mossgrabers.framework.graphics.IGraphicsContext;
import de.mossgrabers.framework.graphics.IGraphicsInfo;
import de.mossgrabers.framework.graphics.canvas.component.IComponent;
import java.util.Arrays;

public class GraphOverlayComponent
implements IComponent {
    private final double x;
    private final double y;
    private final double width;
    private final double height;
    private final ColorEx color;
    private final int[] data;
    private final int maxValue;

    public GraphOverlayComponent(double x, double y, double width, double height, ColorEx color, int[] data, int maxValue) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.color = color;
        this.data = data;
        this.maxValue = maxValue;
    }

    @Override
    public void draw(IGraphicsInfo info) {
        IGraphicsContext gc = info.getContext();
        IGraphicsConfiguration configuration = info.getConfiguration();
        gc.fillRectangle(this.x - 1.0, this.y - 1.0, this.width + 2.0, this.height + 2.0, configuration.getColorBorder());
        double xStep = this.width / (double)(this.data.length - 1);
        double yScale = this.height / (double)this.maxValue;
        double prevX = this.x;
        double prevY = this.y + this.height - (double)Math.round((double)this.data[0] * yScale);
        for (int i = 1; i < this.data.length; ++i) {
            double currX = this.x + (double)Math.round((double)i * xStep);
            double currY = this.y + this.height - (double)Math.round((double)this.data[i] * yScale);
            gc.drawLine(prevX, prevY, currX, currY, this.color);
            prevX = currX;
            prevY = currY;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        result = 31 * result + Arrays.hashCode(this.data);
        long temp = Double.doubleToLongBits(this.height);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.maxValue;
        temp = Double.doubleToLongBits(this.width);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GraphOverlayComponent other = (GraphOverlayComponent)obj;
        if (this.color == null ? other.color != null : !this.color.equals(other.color)) {
            return false;
        }
        if (!Arrays.equals(this.data, other.data) || Double.doubleToLongBits(this.height) != Double.doubleToLongBits(other.height) || this.maxValue != other.maxValue || Double.doubleToLongBits(this.width) != Double.doubleToLongBits(other.width)) {
            return false;
        }
        return Double.doubleToLongBits(this.x) == Double.doubleToLongBits(other.x) && Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }
}

