/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.daw.constants;

import java.util.HashMap;
import java.util.Map;

public enum RecordQuantization {
    RES_OFF("Off", "OFF"),
    RES_1_32("1/32", "1/32"),
    RES_1_16("1/16", "1/16"),
    RES_1_8("1/8", "1/8"),
    RES_1_4("1/4", "1/4");

    private static final Map<String, RecordQuantization> QUANTIZATION_VALUES;
    private final String name;
    private final String value;

    private RecordQuantization(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public static RecordQuantization lookup(String value) {
        return QUANTIZATION_VALUES.getOrDefault(value, RES_OFF);
    }

    static {
        QUANTIZATION_VALUES = new HashMap<String, RecordQuantization>();
        for (RecordQuantization value : RecordQuantization.values()) {
            QUANTIZATION_VALUES.put(value.getValue(), value);
        }
    }
}

