/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.transport;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;

public class WindCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    protected final boolean isFastForwarding;
    private boolean isRewinding;
    private boolean isForwarding;

    public WindCommand(IModel model, S surface, boolean isFastForward) {
        super(model, surface);
        this.isFastForwarding = isFastForward;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (this.isFastForwarding) {
            this.onForward(event, false);
        } else {
            this.onRewind(event, false);
        }
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (this.isFastForwarding) {
            this.onForward(event, true);
        } else {
            this.onRewind(event, true);
        }
    }

    private void onRewind(ButtonEvent event, boolean slow) {
        if (event == ButtonEvent.DOWN) {
            this.isRewinding = true;
        } else if (event == ButtonEvent.UP) {
            this.isRewinding = false;
        }
        this.doChangePosition(slow);
    }

    private void onForward(ButtonEvent event, boolean slow) {
        if (event == ButtonEvent.DOWN) {
            this.isForwarding = true;
        } else if (event == ButtonEvent.UP) {
            this.isForwarding = false;
        }
        this.doChangePosition(slow);
    }

    private void doChangePosition(boolean slow) {
        if (!this.isRewinding && !this.isForwarding) {
            return;
        }
        this.model.getTransport().changePosition(this.isForwarding, slow);
        this.surface.scheduleTask(() -> this.doChangePosition(slow), 100L);
    }

    public boolean isRewinding() {
        return this.isRewinding;
    }

    public boolean isForwarding() {
        return this.isForwarding;
    }
}

