/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.command.trigger.application;

import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.configuration.Configuration;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.IControlSurface;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.ISlot;
import de.mossgrabers.framework.daw.data.bank.ISlotBank;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.Optional;

public class DuplicateCommand<S extends IControlSurface<C>, C extends Configuration>
extends AbstractTriggerCommand<S, C> {
    public DuplicateCommand(IModel model, S surface) {
        super(model, surface);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (this.surface.isSelectPressed()) {
            this.surface.setTriggerConsumed(ButtonID.SELECT);
            if (event == ButtonEvent.UP) {
                this.model.getProject().createScene();
            }
            return;
        }
        super.execute(event, velocity);
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        if (!cursorTrack.doesExist()) {
            return;
        }
        ISlotBank slotBank = cursorTrack.getSlotBank();
        Optional slot = slotBank.getSelectedItem();
        if (slot.isEmpty()) {
            return;
        }
        boolean isPlaying = ((ISlot)slot.get()).isPlaying();
        ((ISlot)slot.get()).duplicate();
        if (!isPlaying) {
            return;
        }
        this.model.getHost().scheduleTask(() -> {
            Optional slotNew = slotBank.getSelectedItem();
            if (slotNew.isPresent()) {
                ((ISlot)slotNew.get()).launch(true, false);
                return;
            }
            slotBank.selectNextPage();
            this.model.getHost().scheduleTask(() -> {
                Optional slotNew2 = slotBank.getSelectedItem();
                if (slotNew2.isPresent()) {
                    ((ISlot)slotNew2.get()).launch(true, false);
                }
            }, 200L);
        }, 200L);
    }

    @Override
    public void executeShifted(ButtonEvent event) {
        if (event == ButtonEvent.UP) {
            this.model.getProject().createSceneFromPlayingLauncherClips();
        }
    }
}

