/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.oxi.one.mode;

import de.mossgrabers.controller.oxi.one.OxiOneConfiguration;
import de.mossgrabers.controller.oxi.one.controller.OxiOneControlSurface;
import de.mossgrabers.controller.oxi.one.mode.IOxiModeReset;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.constants.Resolution;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.graphics.canvas.component.simple.TitleValueMenuComponent;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.TransposeView;
import de.mossgrabers.framework.view.sequencer.AbstractDrumView;
import de.mossgrabers.framework.view.sequencer.AbstractSequencerView;
import java.util.Optional;

public class OxiOneSeqConfigMode
extends AbstractParameterMode<OxiOneControlSurface, OxiOneConfiguration, IItem>
implements IOxiModeReset {
    private static final String[] MENU = new String[]{"Rnge", "Page", "Reso", ""};
    private static final String[] SHIFTED_MENU = new String[]{"", "", "", ""};
    private int selectedIndex = 0;

    public OxiOneSeqConfigMode(OxiOneControlSurface surface, IModel model) {
        super("Seq. Config", surface, model, false);
    }

    @Override
    public void updateDisplay() {
        this.updateSelectedIndex();
        IGraphicDisplay display = ((OxiOneControlSurface)this.surface).getGraphicsDisplay();
        String desc = "";
        Object label = "";
        int value = -1;
        Optional<INoteClip> clipOpt = this.getClip();
        if (clipOpt.isPresent()) {
            INoteClip clip = clipOpt.get();
            int upperBound = this.model.getValueChanger().getUpperBound();
            switch (this.selectedIndex) {
                case 0: {
                    Scales scales = this.model.getScales();
                    label = scales.getDrumRangeText();
                    value = (int)((double)scales.getDrumOffset() / 96.0 * (double)upperBound);
                    break;
                }
                case 1: {
                    label = "Page: " + (clip.getEditPage() + 1);
                    value = 0;
                    break;
                }
                case 2: {
                    int resolutionIndex = this.getResolutionIndex(clip);
                    Resolution resolution = Resolution.values()[resolutionIndex];
                    label = "Resolution: " + resolution.getName();
                    value = (int)((double)resolutionIndex / (double)(Resolution.values().length - 1) * (double)upperBound);
                    break;
                }
            }
        }
        display.addElement(new TitleValueMenuComponent("", (String)label, ((OxiOneControlSurface)this.surface).isShiftPressed() ? SHIFTED_MENU : MENU, value, 0, 0, false));
        display.send();
    }

    private void updateSelectedIndex() {
        if (((OxiOneControlSurface)this.surface).isPressed(ButtonID.SHIFT)) {
            if (this.selectedIndex < 4) {
                this.selectedIndex += 4;
            }
        } else if (this.selectedIndex >= 4) {
            this.selectedIndex -= 4;
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.selectedIndex = ((OxiOneControlSurface)this.surface).isPressed(ButtonID.SHIFT) ? index + 4 : index;
    }

    @Override
    public void onKnobValue(int index, int value) {
        boolean isInc = this.model.getValueChanger().isIncrease(value);
        Optional<INoteClip> clipOpt = this.getClip();
        if (clipOpt.isEmpty()) {
            return;
        }
        INoteClip clip = clipOpt.get();
        switch (this.selectedIndex) {
            case 0: {
                IView activeView = (IView)((OxiOneControlSurface)this.surface).getViewManager().getActive();
                if (activeView instanceof AbstractDrumView) {
                    AbstractDrumView drumView = (AbstractDrumView)activeView;
                    drumView.changeOctave(ButtonEvent.DOWN, isInc, 8, true, false);
                    break;
                }
                if (!(activeView instanceof TransposeView)) break;
                TransposeView transView = (TransposeView)((Object)activeView);
                if (isInc) {
                    transView.onOctaveUp(ButtonEvent.DOWN);
                    break;
                }
                transView.onOctaveDown(ButtonEvent.DOWN);
                break;
            }
            case 1: {
                if (isInc) {
                    clip.scrollStepsPageForward();
                    break;
                }
                clip.scrollStepsPageBackwards();
                break;
            }
            case 2: {
                this.setResolutionIndex(clip, this.getResolutionIndex(clip) + (isInc ? 1 : -1));
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public void resetValue(int index) {
        Optional<INoteClip> clipOpt = this.getClip();
        if (clipOpt.isEmpty()) {
            return;
        }
        INoteClip clip = clipOpt.get();
        switch (this.selectedIndex) {
            case 0: {
                IView activeView = (IView)((OxiOneControlSurface)this.surface).getViewManager().getActive();
                if (!(activeView instanceof AbstractDrumView)) break;
                AbstractDrumView drumView = (AbstractDrumView)activeView;
                drumView.resetOctave();
                break;
            }
            case 1: {
                clip.scrollToPage(0);
                break;
            }
            case 2: {
                clip.setStepLength(Resolution.RES_1_16.getValue());
                break;
            }
        }
    }

    public void setResolutionIndex(INoteClip clip, int selectedResolutionIndex) {
        int resolutionIndex = Math.min(Math.max(0, selectedResolutionIndex), 7);
        Resolution resolution = Resolution.values()[resolutionIndex];
        clip.setStepLength(resolution.getValue());
    }

    public int getResolutionIndex(INoteClip clip) {
        return Resolution.getMatch(clip.getStepLength());
    }

    private Optional<INoteClip> getClip() {
        Object f = ((OxiOneControlSurface)this.surface).getViewManager().getActive();
        if (f instanceof AbstractSequencerView) {
            AbstractSequencerView sequencer = (AbstractSequencerView)f;
            return Optional.of(sequencer.getClip());
        }
        return Optional.empty();
    }
}

