/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchcontrol.mode.main;

import de.mossgrabers.controller.novation.launchcontrol.controller.LaunchControlXLControlSurface;
import de.mossgrabers.controller.novation.launchcontrol.mode.main.XLBaseNoteEditMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.display.IDisplay;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.daw.clip.NotePosition;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameter.NoteAttribute;
import de.mossgrabers.framework.parameter.NoteParameter;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import java.util.ArrayList;
import java.util.List;

public class XLNoteEditMode
extends XLBaseNoteEditMode {
    public XLNoteEditMode(LaunchControlXLControlSurface surface, IModel model, int clipRows, int clipCols, List<ContinuousID> controls) {
        super("Note Sequencer", surface, model, clipRows, clipCols, controls);
        this.defaultMode = Modes.NOTE_SEQUENCER;
        IValueChanger valueChanger = this.model.getValueChanger();
        IDisplay display = surface.getDisplay();
        ArrayList<IParameter> pitchParameters = new ArrayList<IParameter>(8);
        for (int i = 0; i < 8; ++i) {
            pitchParameters.add(new NoteParameter(i, NoteAttribute.PITCH, display, model, this, valueChanger));
        }
        FixedParameterProvider pitchParameterProvider = new FixedParameterProvider(pitchParameters);
        CombinedParameterProvider noteEditProvider = new CombinedParameterProvider(pitchParameterProvider, this.repeatParameterProvider, this.panParameterProvider);
        CombinedParameterProvider noteEditWithDeviceParamsProvider = new CombinedParameterProvider(pitchParameterProvider, this.repeatParameterProvider, this.deviceParameterProvider);
        CombinedParameterProvider shiftedParameterProvider = new CombinedParameterProvider(this.chanceParameterProvider, this.velocitySpreadParameterProvider, this.panParameterProvider);
        this.setParameterProviders(noteEditProvider, noteEditWithDeviceParamsProvider);
        this.setParameterProvider(ButtonID.REC_ARM, shiftedParameterProvider);
    }

    @Override
    protected int getNoteRow(int channel, int step) {
        return this.getClip().getHighestRow(channel, step);
    }

    @Override
    protected void executeRow0(int index) {
        int channel = this.configuration.getMidiEditChannel();
        int noteRow = this.getNoteRow(channel, index);
        INoteClip clip = this.getClip();
        if (noteRow == -1) {
            clip.toggleStep(new NotePosition(channel, index, 60 + this.scales.getScaleOffset()), 127);
        } else {
            clip.clearStep(new NotePosition(channel, index, noteRow));
        }
    }

    @Override
    protected int getFirstRowColor(int index) {
        int channel = this.configuration.getMidiEditChannel();
        int noteRow = this.getNoteRow(channel, index);
        return noteRow < 0 ? 12 : 63;
    }

    @Override
    public void selectPreviousItem() {
        this.scales.prevScale();
        this.scales.updateScaleProperties(this.configuration);
        this.mvHelper.notifyScale(this.scales);
    }

    @Override
    public void selectNextItem() {
        this.scales.nextScale();
        this.scales.updateScaleProperties(this.configuration);
        this.mvHelper.notifyScale(this.scales);
    }

    @Override
    public boolean hasPreviousItem() {
        return this.scales.hasPrevScale();
    }

    @Override
    public boolean hasNextItem() {
        return this.scales.hasNextScale();
    }

    @Override
    protected Modes getSequencerMode() {
        return Modes.NOTE_SEQUENCER;
    }
}

