/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.novation.launchcontrol.mode.buttons;

import de.mossgrabers.controller.novation.launchcontrol.controller.LaunchControlXLControlSurface;
import de.mossgrabers.controller.novation.launchcontrol.mode.buttons.XLTemporaryButtonMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISpecificDevice;
import de.mossgrabers.framework.daw.data.bank.IParameterPageBank;
import de.mossgrabers.framework.utils.ButtonEvent;

public class XLSelectDeviceParamsPageMode
extends XLTemporaryButtonMode {
    private final ISpecificDevice device;

    public XLSelectDeviceParamsPageMode(LaunchControlXLControlSurface surface, IModel model, ISpecificDevice device) {
        super("Select Device Page", surface, model);
        this.device = device;
    }

    @Override
    public void onButton(int row, int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN || row != 0) {
            return;
        }
        this.setHasBeenUsed();
        IParameterPageBank parameterPageBank = this.device.getParameterBank().getPageBank();
        if (index < parameterPageBank.getItemCount()) {
            parameterPageBank.selectPage(index);
            this.mvHelper.notifySelectedDeviceAndParameterPage();
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        int index = buttonID.ordinal() - ButtonID.ROW2_1.ordinal();
        if (index < 0 || index >= 8) {
            return 12;
        }
        IParameterPageBank parameterPageBank = this.device.getParameterBank().getPageBank();
        if (index >= parameterPageBank.getItemCount()) {
            return 12;
        }
        return index == parameterPageBank.getSelectedItemIndex() ? 62 : 29;
    }
}

