/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.mode;

import de.mossgrabers.controller.ni.maschine.Maschine;
import de.mossgrabers.controller.ni.maschine.mk3.MaschineConfiguration;
import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ICursorDevice;
import de.mossgrabers.framework.daw.data.bank.IParameterBank;
import de.mossgrabers.framework.mode.device.SelectedDeviceMode;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameterprovider.device.BankParameterProvider;
import de.mossgrabers.framework.utils.StringUtils;

public class MaschineParametersMode
extends SelectedDeviceMode<MaschineControlSurface, MaschineConfiguration> {
    public MaschineParametersMode(MaschineControlSurface surface, IModel model) {
        super(surface, model, surface.getMaschine().hasMCUDisplay() ? DEFAULT_KNOB_IDS : null, () -> false);
        if (surface.getMaschine().hasMCUDisplay()) {
            this.setParameterProvider(new BankParameterProvider(this.bank));
        }
        this.initTouchedStates(9);
    }

    @Override
    public void updateDisplay() {
        ITextDisplay d = ((MaschineControlSurface)this.surface).getTextDisplay().clear();
        ICursorDevice cd = this.model.getCursorDevice();
        if (!cd.doesExist()) {
            d.notify("Please select a device...");
            return;
        }
        IParameterBank parameterBank = cd.getParameterBank();
        for (int i = 0; i < 8; ++i) {
            Object name;
            IParameter param = (IParameter)parameterBank.getItem(i);
            Object object = name = param.doesExist() ? StringUtils.shortenAndFixASCII(param.getName(), 6) : "";
            if (i == this.getSelectedParameter()) {
                name = ">" + (String)name;
            }
            d.setCell(0, i, (String)name).setCell(1, i, StringUtils.shortenAndFixASCII(param.getDisplayedValue(8), 8));
        }
        d.allDone();
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.setTouchedKnob(index, isTouched);
        super.onKnobTouch(index == 8 ? -1 : index, isTouched);
    }

    @Override
    public void selectPreviousItem() {
        if (((MaschineControlSurface)this.surface).getMaschine() == Maschine.STUDIO && ((MaschineControlSurface)this.surface).isPressed(ButtonID.TRACK)) {
            this.model.getCursorDevice().selectPrevious();
            this.mvHelper.notifySelectedDevice();
            return;
        }
        int selectedParameter = this.getSelectedParameter();
        if (selectedParameter == 0) {
            super.selectPreviousItem();
            this.selectParameter(7);
        } else {
            this.selectParameter(selectedParameter - 1);
        }
    }

    @Override
    public void selectNextItem() {
        if (((MaschineControlSurface)this.surface).getMaschine() == Maschine.STUDIO && ((MaschineControlSurface)this.surface).isPressed(ButtonID.TRACK)) {
            this.model.getCursorDevice().selectNext();
            this.mvHelper.notifySelectedDevice();
            return;
        }
        int selectedParameter = this.getSelectedParameter();
        if (selectedParameter == 7) {
            super.selectNextItem();
            this.selectParameter(0);
        } else {
            this.selectParameter(selectedParameter + 1);
        }
    }

    @Override
    public void selectPreviousItemPage() {
        super.selectPreviousItem();
        this.mvHelper.notifySelectedParameterPage();
    }

    @Override
    public void selectNextItemPage() {
        super.selectNextItem();
        this.mvHelper.notifySelectedParameterPage();
    }

    @Override
    public boolean hasPreviousItem() {
        return this.getSelectedParameter() > 0 || super.hasPreviousItem();
    }

    @Override
    public boolean hasNextItem() {
        return this.getSelectedParameter() < 7 || super.hasNextItem();
    }

    @Override
    public boolean hasPreviousItemPage() {
        return super.hasPreviousItem();
    }

    @Override
    public boolean hasNextItemPage() {
        return super.hasNextItem();
    }
}

