/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.command.trigger;

import de.mossgrabers.controller.ni.maschine.core.RibbonMode;
import de.mossgrabers.controller.ni.maschine.mk3.MaschineConfiguration;
import de.mossgrabers.controller.ni.maschine.mk3.command.continuous.TouchstripCommand;
import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;
import java.util.List;

public class RibbonCommand
extends AbstractTriggerCommand<MaschineControlSurface, MaschineConfiguration> {
    private final List<RibbonMode> modes;
    private RibbonMode activeMode;

    public RibbonCommand(IModel model, MaschineControlSurface surface, List<RibbonMode> modes) {
        super(model, surface);
        this.modes = modes;
        this.activeMode = modes.get(0);
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        MaschineConfiguration configuration = (MaschineConfiguration)((MaschineControlSurface)this.surface).getConfiguration();
        RibbonMode ribbonMode = configuration.getRibbonMode();
        RibbonMode m = this.activeMode;
        int index = this.modes.indexOf((Object)ribbonMode);
        if (index >= 0) {
            if (++index >= this.modes.size()) {
                index = 0;
            }
            m = this.modes.get(index);
        }
        this.activeMode = m;
        ((MaschineControlSurface)this.surface).getDisplay().notify(m.getName());
        configuration.setRibbonMode(m);
        ((TouchstripCommand)((MaschineControlSurface)this.surface).getContinuous(ContinuousID.CROSSFADER).getTouchCommand()).resetRibbonValue(m);
    }
}

