/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.jam.command.trigger;

import de.mossgrabers.controller.ni.maschine.core.command.trigger.EncoderMode;
import de.mossgrabers.controller.ni.maschine.core.controller.EncoderModeManager;
import de.mossgrabers.controller.ni.maschine.jam.MaschineJamConfiguration;
import de.mossgrabers.controller.ni.maschine.jam.controller.MaschineJamControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;

public class MaschineJamViewCommand
extends AbstractTriggerCommand<MaschineJamControlSurface, MaschineJamConfiguration> {
    private final EncoderModeManager<MaschineJamControlSurface, MaschineJamConfiguration> encoderManager;
    private final EncoderMode encoderMode;
    private boolean wasUsed = false;

    public MaschineJamViewCommand(EncoderModeManager<MaschineJamControlSurface, MaschineJamConfiguration> encoderManager, EncoderMode encoderMode, IModel model, MaschineJamControlSurface surface) {
        super(model, surface);
        this.encoderManager = encoderManager;
        this.encoderMode = encoderMode;
    }

    @Override
    public void executeNormal(ButtonEvent event) {
        switch (event) {
            case LONG: {
                this.wasUsed = true;
                return;
            }
            case DOWN: {
                this.wasUsed = false;
                this.encoderManager.enableTemporaryEncodeMode(this.encoderMode);
                if (this.encoderMode != EncoderMode.TEMPORARY_LOCK) break;
                ((MaschineJamControlSurface)this.surface).getViewManager().setTemporary(Views.CONTROL);
                break;
            }
            case UP: {
                this.encoderManager.disableTemporaryEncodeMode();
                if (!this.wasUsed && this.encoderMode == EncoderMode.TEMPORARY_LOCK) {
                    MaschineJamConfiguration configuration;
                    configuration.setAccentEnabled(!(configuration = (MaschineJamConfiguration)((MaschineJamControlSurface)this.surface).getConfiguration()).isAccentActive());
                }
                if (this.encoderMode != EncoderMode.TEMPORARY_LOCK) break;
                ((MaschineJamControlSurface)this.surface).getViewManager().restore();
            }
        }
    }
}

