/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.mackie.mcu.mode;

import de.mossgrabers.controller.mackie.mcu.controller.MCUControlSurface;
import de.mossgrabers.controller.mackie.mcu.mode.BaseMode;
import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IMarker;
import de.mossgrabers.framework.daw.data.bank.IMarkerBank;
import de.mossgrabers.framework.utils.StringUtils;

public class MarkerMode
extends BaseMode<IMarker> {
    public MarkerMode(MCUControlSurface surface, IModel model) {
        super("Marker", surface, model);
    }

    @Override
    public void onKnobValue(int index, int value) {
    }

    @Override
    public void updateDisplay() {
        ITextDisplay d = ((MCUControlSurface)this.surface).getTextDisplay().clear();
        ColorEx[] colors = new ColorEx[8];
        IMarkerBank markerBank = this.model.getMarkerBank();
        int extenderOffset = ((MCUControlSurface)this.surface).getExtenderOffset();
        int textLength = this.getTextLength();
        for (int i = 0; i < 8; ++i) {
            IMarker marker = (IMarker)markerBank.getItem(extenderOffset + i);
            d.setCell(0, i, StringUtils.shortenAndFixASCII(marker.getName(), textLength));
            colors[i] = MarkerMode.preventBlack(marker.doesExist(), marker.getColor());
        }
        d.allDone();
        ((MCUControlSurface)this.surface).sendDisplayColor(colors);
    }

    @Override
    protected void resetParameter(int index) {
        int extenderOffset = ((MCUControlSurface)this.surface).getExtenderOffset();
        IMarker item = (IMarker)this.model.getMarkerBank().getItem(extenderOffset + index);
        if (!item.doesExist()) {
            return;
        }
        if (((MCUControlSurface)this.surface).isShiftPressed()) {
            item.select();
        } else {
            item.launch(true);
        }
    }

    @Override
    public void updateKnobLEDs() {
        int extenderOffset = ((MCUControlSurface)this.surface).getExtenderOffset();
        IMarkerBank markerBank = this.model.getMarkerBank();
        for (int i = 0; i < 8; ++i) {
            boolean exists = ((IMarker)markerBank.getItem(extenderOffset + i)).doesExist();
            ((MCUControlSurface)this.surface).setKnobLED(i, 2, 0, exists ? 1 : 0);
        }
    }
}

