/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode.track;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.Push1Display;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.track.AbstractTrackMode;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.parameterprovider.track.VolumeParameterProvider;

public class VolumeMode
extends AbstractTrackMode {
    public VolumeMode(PushControlSurface surface, IModel model) {
        super("Volume", surface, model);
        this.setParameterProvider(new VolumeParameterProvider(model));
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        ITrackBank tb = this.model.getCurrentTrackBank();
        PushConfiguration config = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        int upperBound = this.model.getValueChanger().getUpperBound();
        for (int i = 0; i < 8; ++i) {
            ITrack t = (ITrack)tb.getItem(i);
            display.setCell(0, i, t.doesExist() ? "Volume" : "").setCell(1, i, t.getVolumeStr(8));
            if (!t.doesExist()) continue;
            display.setCell(2, i, config.isEnableVUMeters() ? Push1Display.formatValue(t.getVolume(), t.getVu(), upperBound) : Push1Display.formatValue(t.getVolume(), upperBound));
        }
        this.drawRow4(display);
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        this.updateChannelDisplay(display, 1, true, false);
    }
}

