/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode.track;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.BaseMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.constants.Capability;
import de.mossgrabers.framework.daw.data.ICursorTrack;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ITrackBank;
import de.mossgrabers.framework.daw.resource.ChannelType;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.ColorSelectMode;
import de.mossgrabers.framework.view.ColorView;
import de.mossgrabers.framework.view.Views;
import java.util.Optional;

public class TrackDetailsMode
extends BaseMode<ITrack> {
    private final boolean hasPinning;

    public TrackDetailsMode(PushControlSurface surface, IModel model) {
        super("Track details", surface, model, model.getCurrentTrackBank());
        this.hasPinning = this.model.getHost().supports(Capability.HAS_PINNING);
        TrackDetailsMode trackDetailsMode = this;
        model.addTrackBankObserver(x$0 -> trackDetailsMode.switchBanks(x$0));
    }

    @Override
    public void onKnobValue(int index, int value) {
        if (index < 6) {
            return;
        }
        PushConfiguration configuration = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        int speed = this.model.getValueChanger().isIncrease(value) ? 1 : -1;
        configuration.setMidiEditChannel(configuration.getMidiEditChannel() + speed);
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (this.model.getMasterTrack().isSelected()) {
            this.onFirstRowMasterTrack(index);
        } else {
            this.onFirstRowTrack(index);
        }
    }

    private void onFirstRowMasterTrack(int index) {
        switch (index) {
            case 0: {
                this.model.getMasterTrack().toggleIsActivated();
                break;
            }
            case 1: {
                this.model.getMasterTrack().toggleRecArm();
                break;
            }
            case 2: {
                this.model.getMasterTrack().toggleMute();
                break;
            }
            case 3: {
                this.model.getMasterTrack().toggleSolo();
                break;
            }
            case 4: {
                this.model.getMasterTrack().toggleMonitor();
                break;
            }
            case 5: {
                this.model.getMasterTrack().toggleAutoMonitor();
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
                ((ColorView)viewManager.get(Views.COLOR)).setMode(ColorSelectMode.MODE_TRACK);
                viewManager.setActive(Views.COLOR);
                break;
            }
        }
    }

    private void onFirstRowTrack(int index) {
        ITrackBank tb = this.model.getCurrentTrackBank();
        Optional track = tb.getSelectedItem();
        if (track.isEmpty()) {
            return;
        }
        ITrack t = (ITrack)track.get();
        switch (index) {
            case 0: {
                t.toggleIsActivated();
                break;
            }
            case 1: {
                t.toggleRecArm();
                break;
            }
            case 2: {
                t.toggleMute();
                break;
            }
            case 3: {
                t.toggleSolo();
                break;
            }
            case 4: {
                t.toggleMonitor();
                break;
            }
            case 5: {
                t.toggleAutoMonitor();
                break;
            }
            case 6: {
                this.model.getCursorTrack().togglePinned();
                break;
            }
            case 7: {
                ViewManager viewManager = ((PushControlSurface)this.surface).getViewManager();
                ((ColorView)viewManager.get(Views.COLOR)).setMode(ColorSelectMode.MODE_TRACK);
                viewManager.setActive(Views.COLOR);
                break;
            }
        }
    }

    @Override
    public int getButtonColor(ButtonID buttonID) {
        int index = this.isButtonRow(0, buttonID);
        if (index >= 0) {
            ICursorTrack cursorTrack = this.model.getCursorTrack();
            if (!cursorTrack.doesExist()) {
                return super.getButtonColor(buttonID);
            }
            switch (index) {
                case 0: {
                    return this.colorManager.getColorIndex(cursorTrack.isActivated() ? "PUSH_YELLOW_MD" : "PUSH_YELLOW_LO");
                }
                case 1: {
                    return this.colorManager.getColorIndex(cursorTrack.isRecArm() ? "PUSH_RED_HI" : "PUSH_RED_LO");
                }
                case 2: {
                    return this.colorManager.getColorIndex(cursorTrack.isMute() ? "PUSH_ORANGE_HI" : "PUSH_ORANGE_LO");
                }
                case 3: {
                    return this.colorManager.getColorIndex(cursorTrack.isSolo() ? "PUSH_ORANGE_HI" : "PUSH_ORANGE_LO");
                }
                case 4: {
                    return this.colorManager.getColorIndex(cursorTrack.isMonitor() ? "PUSH_GREEN_HI" : "PUSH_GREEN_LO");
                }
                case 5: {
                    return this.colorManager.getColorIndex(cursorTrack.isAutoMonitor() ? "PUSH_GREEN_HI" : "PUSH_GREEN_LO");
                }
                case 6: {
                    if (!this.hasPinning) {
                        return this.isPushModern ? 0 : 0;
                    }
                    return this.colorManager.getColorIndex(cursorTrack.isPinned() ? "PUSH_GREEN_HI" : "PUSH_GREEN_LO");
                }
            }
            return this.isPushModern ? 21 : 22;
        }
        index = this.isButtonRow(1, buttonID);
        if (index >= 0) {
            return this.colorManager.getColorIndex(index < 6 ? "BUTTON_COLOR_OFF" : "BUTTON_COLOR_ON");
        }
        return this.colorManager.getColorIndex("BUTTON_COLOR_OFF");
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        PushConfiguration configuration = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
        switch (index) {
            case 6: {
                configuration.setMidiEditChannel(configuration.getMidiEditChannel() - 1);
                break;
            }
            case 7: {
                configuration.setMidiEditChannel(configuration.getMidiEditChannel() + 1);
                break;
            }
        }
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        if (!cursorTrack.doesExist()) {
            display.setRow(1, "                     Please selecta track...                        ");
            return;
        }
        String trackName = cursorTrack.getName();
        String firstBlock = TrackDetailsMode.getTrackTitle(cursorTrack) + trackName;
        display.setBlock(0, 0, firstBlock);
        if (firstBlock.length() > 17) {
            display.setBlock(0, 1, firstBlock.substring(17).trim());
        }
        display.setCell(2, 0, "Active").setCell(3, 0, cursorTrack.isActivated() ? "On" : "Off");
        display.setCell(2, 1, "Rec Arm");
        display.setCell(3, 1, cursorTrack.isRecArm() ? "On" : "Off");
        display.setCell(2, 2, "Mute").setCell(3, 2, cursorTrack.isMute() ? "On" : "Off");
        display.setCell(2, 3, "Solo").setCell(3, 3, cursorTrack.isSolo() ? "On" : "Off");
        display.setCell(2, 4, "Monitor");
        display.setCell(3, 4, cursorTrack.isMonitor() ? "On" : "Off");
        display.setCell(2, 5, "Auto Monitor");
        display.setCell(3, 5, cursorTrack.isAutoMonitor() ? "On" : "Off");
        if (this.hasPinning) {
            display.setCell(2, 6, "Pin Trck");
            display.setCell(3, 6, this.model.getCursorTrack().isPinned() ? "On" : "Off");
        }
        display.setCell(2, 7, "Select").setCell(3, 7, "Color");
        display.setCell(0, 5, "Midi Ins");
        display.setBlock(0, 3, "/Edit Channel: " + (((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).getMidiEditChannel() + 1));
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        ICursorTrack cursorTrack = this.model.getCursorTrack();
        if (!cursorTrack.doesExist()) {
            display.setMessage(3, "Please select a track...");
            return;
        }
        display.addOptionElement(TrackDetailsMode.getTrackTitle(cursorTrack) + cursorTrack.getName(), "", false, "", "Active", cursorTrack.isActivated(), false);
        display.addOptionElement("", "", false, "", "Rec Arm", cursorTrack.isRecArm(), false);
        display.addOptionElement("", "", false, "", "Mute", cursorTrack.isMute(), false);
        display.addOptionElement("", "", false, "", "Solo", cursorTrack.isSolo(), false);
        display.addOptionElement("", "", false, "", "Monitor", cursorTrack.isMonitor(), false);
        display.addOptionElement("Midi Insert/Edit Channel:", "", false, "", "Auto Monitor", cursorTrack.isAutoMonitor(), false);
        if (this.hasPinning) {
            display.addOptionElement("", "", false, "", "Pin Track", this.model.getCursorTrack().isPinned(), false);
        } else {
            display.addEmptyElement();
        }
        display.addOptionElement("        " + (((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).getMidiEditChannel() + 1), "", false, "", "Select Color", false, false);
    }

    private static String getTrackTitle(ITrack track) {
        return ChannelType.getLabel(track.getType()) + " Track: ";
    }
}

