/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.mode;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.controller.Push1Display;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.controller.ableton.push.mode.BaseMode;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.utils.ButtonEvent;

public class RibbonMode
extends BaseMode<IItem> {
    private static final int[] MIDI_CCS = new int[]{1, 11, 7, 64};
    private static final String[] TOP_HEADERS = new String[]{"CC", "Quick Select", "", "", "", "Note Repeat", "", ""};
    private static final String[] BOTTOM_HEADERS = new String[]{"Function", "", "", "", "", "", "", ""};
    private static final String[] TOP_OPTIONS = new String[]{"", "Modulation", "Expression", "Volume", "Sustain", "Off", "Period", "Length"};
    private static final String[] BOTTOM_OPTIONS = new String[]{"Pitchbend", "CC", "CC/Pitch", "Pitch/CC", "Fader", "Last Touched", "", ""};
    private static final int[] FUNCTION_IDS = new int[]{0, 1, 2, 3, 4, 5};
    private static final String[] NOTE_REPEAT_NAMES = new String[]{"    Off", " Period", " Length"};
    private static final String[] NOTE_REPEAT_NAMES_SELECTED = new String[]{"    " + Push1Display.SELECT_ARROW + "Off", Push1Display.SELECT_ARROW + "Period", Push1Display.SELECT_ARROW + "Length"};
    private static final String[] FUNCTION_NAMES = new String[]{"Pitchbnd", "   CC   ", "CC/Pitch", "Pitch/CC", " Fader  ", " Touched"};
    private static final String[] FUNCTION_NAMES_SELECTED = new String[]{Push1Display.SELECT_ARROW + "Pitchbd", "  " + Push1Display.SELECT_ARROW + "CC   ", Push1Display.SELECT_ARROW + "CC/Ptch", Push1Display.SELECT_ARROW + "Ptch/CC", Push1Display.SELECT_ARROW + "Fader  ", Push1Display.SELECT_ARROW + "Touched"};
    private final PushConfiguration configuration;

    public RibbonMode(PushControlSurface surface, IModel model) {
        super("Ribbon", surface, model);
        this.configuration = (PushConfiguration)((PushControlSurface)this.surface).getConfiguration();
    }

    @Override
    public void onKnobValue(int index, int value) {
        if (index == 0) {
            this.configuration.setRibbonModeCC(this.model.getValueChanger().changeValue(value, this.configuration.getRibbonModeCCVal(), -100.0, 128));
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.setTouchedKnob(index, isTouched);
    }

    @Override
    public void onFirstRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP) {
            return;
        }
        if (index < FUNCTION_IDS.length) {
            this.configuration.setRibbonMode(index);
        } else {
            ((PushControlSurface)this.surface).getModeManager().restore();
        }
    }

    @Override
    public void onSecondRow(int index, ButtonEvent event) {
        if (event != ButtonEvent.UP || index == 0) {
            return;
        }
        if (index < 5) {
            ((PushConfiguration)((PushControlSurface)this.surface).getConfiguration()).setRibbonModeCC(MIDI_CCS[index - 1]);
        } else {
            this.configuration.setRibbonNoteRepeat(index - 5);
        }
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        int index = this.isButtonRow(0, buttonID);
        if (index >= 0) {
            if (index < FUNCTION_IDS.length) {
                return this.configuration.getRibbonMode() == 0 + index ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON";
            }
            return "BUTTON_COLOR_OFF";
        }
        index = this.isButtonRow(1, buttonID);
        if (index >= 0) {
            if (index == 0) {
                return "BUTTON_COLOR_OFF";
            }
            if (index < 5) {
                return this.isPushModern ? "BUTTON_COLOR_ON" : "BUTTON_COLOR2_ON";
            }
            return this.configuration.getRibbonNoteRepeat() == index - 5 ? "BUTTON_COLOR_HI" : "BUTTON_COLOR_ON";
        }
        return "BUTTON_COLOR_OFF";
    }

    @Override
    public void updateDisplay1(ITextDisplay display) {
        String ribbonModeCC = Integer.toString(this.configuration.getRibbonModeCCVal());
        int ribbonMode = this.configuration.getRibbonMode();
        int noteRepeat = this.configuration.getRibbonNoteRepeat();
        display.setCell(0, 0, "CC: " + ribbonModeCC).setCell(0, 1, "Modulatn").setCell(0, 2, "Expressn").setCell(0, 3, "Volume").setCell(0, 4, "Sustain");
        display.setCell(1, 1, "CC Quick").setCell(1, 2, "Select").setCell(1, 5, "    Note").setCell(1, 6, "Repeat");
        display.setCell(2, 0, "Function");
        display.setCell(3, 0, ribbonMode == 0 ? FUNCTION_NAMES_SELECTED[0] : FUNCTION_NAMES[0]);
        display.setCell(3, 1, ribbonMode == 1 ? FUNCTION_NAMES_SELECTED[1] : FUNCTION_NAMES[1]);
        display.setCell(3, 2, ribbonMode == 2 ? FUNCTION_NAMES_SELECTED[2] : FUNCTION_NAMES[2]);
        display.setCell(3, 3, ribbonMode == 3 ? FUNCTION_NAMES_SELECTED[3] : FUNCTION_NAMES[3]);
        display.setCell(3, 4, ribbonMode == 4 ? FUNCTION_NAMES_SELECTED[4] : FUNCTION_NAMES[4]);
        display.setCell(3, 5, ribbonMode == 5 ? FUNCTION_NAMES_SELECTED[5] : FUNCTION_NAMES[5]);
        for (int i = 0; i < 3; ++i) {
            display.setCell(0, 5 + i, noteRepeat == i ? NOTE_REPEAT_NAMES_SELECTED[i] : NOTE_REPEAT_NAMES[i]);
        }
    }

    @Override
    public void updateDisplay2(IGraphicDisplay display) {
        int ribbonMode = this.configuration.getRibbonMode();
        int ribbonNoteRepeat = this.configuration.getRibbonNoteRepeat();
        for (int i = 0; i < 8; ++i) {
            boolean isMenuTopSelected = true;
            String menuTopName = TOP_OPTIONS[i];
            if (i == 0) {
                menuTopName = Integer.toString(this.configuration.getRibbonModeCCVal());
            } else {
                isMenuTopSelected = i > 4 && ribbonNoteRepeat == i - 5;
            }
            display.addOptionElement(TOP_HEADERS[i], menuTopName, isMenuTopSelected, BOTTOM_HEADERS[i], BOTTOM_OPTIONS[i], i < FUNCTION_IDS.length && ribbonMode == FUNCTION_IDS[i], false);
        }
    }
}

