/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.ui.widget;

import de.mossgrabers.reaper.ui.widget.ControllerCheckboxListItem;
import de.mossgrabers.reaper.ui.widget.Functions;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class CheckboxListRenderer
extends JCheckBox
implements ListCellRenderer<ControllerCheckboxListItem> {
    private static final long serialVersionUID = -6249149996532470179L;
    private final ImageIcon iconOff = Functions.getIcon("ControllerOff", 16);
    private final ImageIcon iconEnabled = Functions.getIcon("ControllerEnabled", 16);
    private final ImageIcon iconRunning = Functions.getIcon("ControllerRunning", 16);

    public CheckboxListRenderer() {
        this.setIconTextGap(10);
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends ControllerCheckboxListItem> list, ControllerCheckboxListItem value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setEnabled(list.isEnabled());
        if (value.isSelected()) {
            this.setIcon(value.isRunning() ? this.iconRunning : this.iconEnabled);
            this.setToolTipText(value.isRunning() ? "Controller is running" : "Controller is enabled but not connected");
        } else {
            this.setIcon(this.iconOff);
            this.setToolTipText("Controller is off");
        }
        this.setFont(list.getFont());
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        this.setText(value.toString());
        return this;
    }
}

