/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.osc;

import com.illposed.osc.OSCBadDataEvent;
import com.illposed.osc.OSCBundle;
import com.illposed.osc.OSCMessage;
import com.illposed.osc.OSCPacket;
import com.illposed.osc.OSCPacketEvent;
import com.illposed.osc.OSCPacketListener;
import com.illposed.osc.transport.OSCPortIn;
import de.mossgrabers.framework.osc.IOpenSoundControlCallback;
import de.mossgrabers.framework.osc.IOpenSoundControlServer;
import de.mossgrabers.reaper.framework.osc.OpenSoundControlMessageImpl;
import de.mossgrabers.reaper.ui.utils.LogModel;
import de.mossgrabers.reaper.ui.utils.SafeRunLater;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OpenSoundControlServerImpl
implements IOpenSoundControlServer {
    private final IOpenSoundControlCallback callback;
    private final Object receiverLock = new Object();
    private final LogModel logModel;
    private OSCPortIn oscReceiver;
    private int port = -1;

    public OpenSoundControlServerImpl(IOpenSoundControlCallback callback, LogModel logModel) {
        this.callback = callback;
        this.logModel = logModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(int port) throws IOException {
        Object object = this.receiverLock;
        synchronized (object) {
            this.port = port;
            this.close();
            this.oscReceiver = new OSCPortIn(port);
            this.oscReceiver.addPacketListener((OSCPacketListener)new PacketListener());
            this.oscReceiver.startListening();
        }
    }

    @Override
    public int getListeningPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.receiverLock;
        synchronized (object) {
            if (this.oscReceiver == null) {
                return;
            }
            this.oscReceiver.stopListening();
            try {
                this.oscReceiver.close();
            }
            catch (IOException ex) {
                this.logModel.error("Could not close OSC receiver.", ex);
            }
        }
    }

    private class PacketListener
    implements OSCPacketListener {
        private PacketListener() {
        }

        public void handlePacket(OSCPacketEvent event) {
            ArrayList<OSCMessage> messages = new ArrayList<OSCMessage>();
            this.collectMessages(messages, event.getPacket());
            SafeRunLater.execute(OpenSoundControlServerImpl.this.logModel, () -> {
                for (OSCMessage message : messages) {
                    OpenSoundControlServerImpl.this.callback.handle(new OpenSoundControlMessageImpl(message));
                }
            });
        }

        public void handleBadData(OSCBadDataEvent event) {
            OpenSoundControlServerImpl.this.logModel.error("Could not parse message.", (Throwable)event.getException());
        }

        private void collectMessages(List<OSCMessage> messages, OSCPacket packet) {
            if (packet instanceof OSCMessage) {
                OSCMessage osc = (OSCMessage)packet;
                messages.add(osc);
            } else if (packet instanceof OSCBundle) {
                OSCBundle bundle = (OSCBundle)packet;
                for (OSCPacket op : bundle.getPackets()) {
                    this.collectMessages(messages, op);
                }
            }
        }
    }
}

