/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.daw.data.parameter;

import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.parameter.AbstractParameterImpl;
import de.mossgrabers.reaper.communication.Processor;
import de.mossgrabers.reaper.framework.daw.DataSetupEx;

public class MetronomeVolumeParameterImpl
extends AbstractParameterImpl {
    private final DataSetupEx dataSetup;
    private static final double DEFAULT_VOLUME = 0.592449;
    private double metronomeVolume = 0.592449;
    private String metronomeVolumeStr = "0.0";

    public MetronomeVolumeParameterImpl(DataSetupEx dataSetup) {
        super(dataSetup.getValueChanger(), -1);
        this.dataSetup = dataSetup;
    }

    @Override
    public void setValue(IValueChanger valueChanger, int value) {
        this.setNormalizedValue(valueChanger.toNormalizedValue(value));
    }

    @Override
    public void setNormalizedValue(double value) {
        this.metronomeVolume = value;
        this.dataSetup.getSender().processIntArg(Processor.METRO_VOL, (int)Math.round(this.metronomeVolume * 127.0));
    }

    @Override
    public int getValue() {
        return this.valueChanger.fromNormalizedValue(Math.max(this.metronomeVolume, 0.0));
    }

    @Override
    public void changeValue(IValueChanger valueChanger, int value) {
        this.setValue(valueChanger.changeValue(value, this.getValue()));
    }

    @Override
    public void resetValue() {
        this.setNormalizedValue(0.592449);
    }

    @Override
    public void inc(double increment) {
        this.dataSetup.getSender().processNoArg(Processor.METRO_VOL, increment > 0.0 ? "+" : "-");
    }

    @Override
    public String getDisplayedValue() {
        return this.metronomeVolumeStr;
    }

    public void setInternalMetronomeVolume(double metronomeVolume) {
        this.metronomeVolume = metronomeVolume;
    }

    public void setMetronomeVolumeStr(String metronomeVolumeStr) {
        this.metronomeVolumeStr = metronomeVolumeStr;
    }
}

