/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.reaper.framework.configuration;

import de.mossgrabers.framework.utils.Pair;
import de.mossgrabers.reaper.communication.BackendExchange;
import de.mossgrabers.reaper.framework.configuration.AbstractSettingsUI;
import de.mossgrabers.reaper.framework.configuration.IfxSetting;
import de.mossgrabers.reaper.framework.midi.MidiAccessImpl;
import de.mossgrabers.reaper.framework.midi.MidiDeviceConverter;
import de.mossgrabers.reaper.framework.midi.MissingMidiDevice;
import de.mossgrabers.reaper.ui.utils.LogModel;
import de.mossgrabers.reaper.ui.utils.PropertiesEx;
import de.mossgrabers.reaper.ui.utils.SafeRunLater;
import de.mossgrabers.reaper.ui.widget.JComboBoxX;
import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.MidiDevice;

public class GlobalSettingsUI
extends AbstractSettingsUI {
    private static final String TAG_IS_ENABLED = "TAG_IS_ENABLED";
    private static final String TAG_MIDI_INPUT = "MIDI_INPUT";
    private static final String TAG_MIDI_OUTPUT = "MIDI_OUTPUT";
    private final int numMidiInPorts;
    private final int numMidiOutPorts;
    private final List<Pair<String[], String[]>> discoveryPairs;
    private boolean isEnabled = true;
    private final MidiDevice[] selectedMidiInputs;
    private final MidiDevice[] selectedMidiOutputs;

    public GlobalSettingsUI(BackendExchange sender, LogModel logModel, PropertiesEx properties, int numMidiInPorts, int numMidiOutPorts, List<Pair<String[], String[]>> discoveryPairs) {
        super(logModel, properties, sender);
        this.numMidiInPorts = numMidiInPorts;
        this.numMidiOutPorts = numMidiOutPorts;
        this.discoveryPairs = discoveryPairs;
        this.selectedMidiInputs = new MidiDevice[this.numMidiInPorts];
        this.selectedMidiOutputs = new MidiDevice[this.numMidiOutPorts];
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public MidiDevice getSelectedMidiInput(int index) {
        return this.selectedMidiInputs[index];
    }

    public MidiDevice getSelectedMidiOutput(int index) {
        return this.selectedMidiOutputs[index];
    }

    public MidiDevice[] getSelectedMidiInputs() {
        return this.selectedMidiInputs;
    }

    public MidiDevice[] getSelectedMidiOutputs() {
        return this.selectedMidiOutputs;
    }

    public List<JComboBoxX<MidiDevice>> createMidiInputWidgets() {
        ArrayList<JComboBoxX<MidiDevice>> midiInputs = new ArrayList<JComboBoxX<MidiDevice>>();
        int i = 0;
        while (i < this.numMidiInPorts) {
            JComboBoxX<Object> midiInput = new JComboBoxX<Object>();
            midiInput.setRenderer(new MidiDeviceConverter());
            midiInputs.add(midiInput);
            int index = i++;
            midiInput.addItemListener(event -> SafeRunLater.execute(this.logModel, () -> {
                MidiDevice selectedItem = (MidiDevice)midiInput.getSelectedItem();
                if (selectedItem != null) {
                    this.selectedMidiInputs[index] = selectedItem;
                }
            }));
        }
        return midiInputs;
    }

    public List<JComboBoxX<MidiDevice>> createMidiOutputWidgets() {
        ArrayList<JComboBoxX<MidiDevice>> midiOutputs = new ArrayList<JComboBoxX<MidiDevice>>();
        int i = 0;
        while (i < this.numMidiOutPorts) {
            JComboBoxX<Object> midiOutput = new JComboBoxX<Object>();
            midiOutput.setRenderer(new MidiDeviceConverter());
            midiOutputs.add(midiOutput);
            int index = i++;
            midiOutput.addActionListener(event -> SafeRunLater.execute(this.logModel, () -> {
                MidiDevice selectedItem = (MidiDevice)midiOutput.getSelectedItem();
                if (selectedItem != null) {
                    this.selectedMidiOutputs[index] = (MidiDevice)midiOutput.getSelectedItem();
                }
            }));
        }
        return midiOutputs;
    }

    public void initMIDI() {
        String name;
        int i;
        this.isEnabled = this.properties.getBoolean(TAG_IS_ENABLED, true);
        for (i = 0; i < this.numMidiInPorts; ++i) {
            name = this.properties.getString(TAG_MIDI_INPUT + i);
            if (name == null) {
                for (Pair<String[], String[]> pair : this.discoveryPairs) {
                    this.selectedMidiInputs[i] = MidiAccessImpl.getInputDevice(pair.getKey()[i]);
                    if (this.selectedMidiInputs[i] == null) continue;
                    break;
                }
                if (this.selectedMidiInputs[i] != null) continue;
                this.selectedMidiInputs[i] = MissingMidiDevice.NONE;
                continue;
            }
            this.selectedMidiInputs[i] = MidiAccessImpl.getInputDevice(name);
            if (this.selectedMidiInputs[i] != null) continue;
            this.selectedMidiInputs[i] = new MissingMidiDevice("Not present: " + name);
        }
        for (i = 0; i < this.numMidiOutPorts; ++i) {
            name = this.properties.getString(TAG_MIDI_OUTPUT + i);
            if (name == null) {
                for (Pair<String[], String[]> pair : this.discoveryPairs) {
                    this.selectedMidiOutputs[i] = MidiAccessImpl.getOutputDevice(pair.getValue()[i]);
                    if (this.selectedMidiOutputs[i] == null) continue;
                    break;
                }
                if (this.selectedMidiOutputs[i] != null) continue;
                this.selectedMidiOutputs[i] = MissingMidiDevice.NONE;
                continue;
            }
            this.selectedMidiOutputs[i] = MidiAccessImpl.getOutputDevice(name);
            if (this.selectedMidiOutputs[i] != null) continue;
            this.selectedMidiOutputs[i] = new MissingMidiDevice("Not present: " + name);
        }
    }

    public void store(PropertiesEx properties) {
        MidiDevice midiDevice;
        int i;
        properties.putBoolean(TAG_IS_ENABLED, this.isEnabled);
        for (i = 0; i < this.numMidiInPorts; ++i) {
            midiDevice = this.getSelectedMidiInput(i);
            if (midiDevice instanceof MissingMidiDevice) continue;
            properties.putString(TAG_MIDI_INPUT + i, midiDevice.getDeviceInfo().getName());
        }
        for (i = 0; i < this.numMidiOutPorts; ++i) {
            midiDevice = this.getSelectedMidiOutput(i);
            if (midiDevice instanceof MissingMidiDevice) continue;
            properties.putString(TAG_MIDI_OUTPUT + i, midiDevice.getDeviceInfo().getName());
        }
        this.settings.forEach(s -> s.store(properties));
    }

    public boolean isDirty() {
        for (IfxSetting setting : this.settings) {
            if (!setting.isDirty()) continue;
            return true;
        }
        return false;
    }
}

