/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.utils;

import de.mossgrabers.framework.daw.IHost;

public class TimeoutOptimizer {
    private static final int RUNS = 30;
    private final IHost host;
    private int delay;
    private long startValue;
    private int iterations = 0;
    private long diff;

    public TimeoutOptimizer(IHost host, int delay) {
        this.host = host;
        this.delay = delay;
        this.startValue = System.currentTimeMillis();
        this.host.scheduleTask(this::measure, delay);
    }

    private void measure() {
        long endValue = System.currentTimeMillis();
        this.diff += endValue - this.startValue;
        if (this.iterations < 30) {
            ++this.iterations;
            this.startValue = System.currentTimeMillis();
            this.host.scheduleTask(this::measure, this.delay);
        } else {
            long effective = this.diff / 30L;
            this.delay = (int)((long)(this.delay * this.delay) / effective);
        }
    }

    public int getTimeout() {
        return this.delay;
    }
}

