/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.framework.graphics.canvas.component;

import de.mossgrabers.framework.controller.color.ColorEx;
import de.mossgrabers.framework.graphics.IGraphicsInfo;
import de.mossgrabers.framework.graphics.canvas.component.IComponent;
import de.mossgrabers.framework.graphics.canvas.component.LabelComponent;

public class MenuComponent
implements IComponent {
    protected final LabelComponent header;
    protected final LabelComponent footer;

    public MenuComponent(String menuName, boolean isMenuSelected, String name, String icon, ColorEx color, boolean isSelected, boolean isActive) {
        this(menuName, isMenuSelected, name, icon, color, isSelected, isActive, LabelComponent.LabelLayout.COLORED);
    }

    public MenuComponent(String menuName, boolean isMenuSelected, String name, String icon, ColorEx color, boolean isSelected, boolean isActive, LabelComponent.LabelLayout lowerLayout) {
        this.header = new LabelComponent(menuName, null, null, isMenuSelected, true, LabelComponent.LabelLayout.SMALL_HEADER);
        this.footer = new LabelComponent(name, icon, color, isSelected, isActive, lowerLayout);
    }

    @Override
    public void draw(IGraphicsInfo info) {
        this.header.draw(info);
        String name = this.footer.getText();
        if (name == null || name.length() == 0) {
            return;
        }
        double menuHeight = 2.0 * info.getDimensions().getMenuHeight();
        this.footer.draw(info.withBounds(info.getBounds().height() - menuHeight, menuHeight));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.footer == null ? 0 : this.footer.hashCode());
        result = 31 * result + (this.header == null ? 0 : this.header.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MenuComponent other = (MenuComponent)obj;
        if (this.footer == null ? other.footer != null : !this.footer.equals(other.footer)) {
            return false;
        }
        return !(this.header == null ? other.header != null : !this.header.equals(other.header));
    }
}

