/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.utilities.autocolor;

import de.mossgrabers.framework.configuration.AbstractConfiguration;
import de.mossgrabers.framework.configuration.IEnumSetting;
import de.mossgrabers.framework.configuration.ISettingsUI;
import de.mossgrabers.framework.configuration.IStringSetting;
import de.mossgrabers.framework.controller.valuechanger.IValueChanger;
import de.mossgrabers.framework.daw.DAWColor;
import de.mossgrabers.framework.daw.IHost;
import java.util.EnumMap;
import java.util.Map;

public class AutoColorConfiguration
extends AbstractConfiguration {
    private static final String CATEGORY_AUTO_COLOR = "Auto Color";
    public static final Integer ENABLE_AUTO_COLOR = 100;
    public static final Integer COLOR_REGEX = 101;
    private boolean enableAutoColor;
    private final Map<DAWColor, String> colorRegEx = new EnumMap<DAWColor, String>(DAWColor.class);

    public AutoColorConfiguration(IHost host, IValueChanger valueChanger) {
        super(host, valueChanger, null);
    }

    @Override
    public void init(ISettingsUI globalSettings, ISettingsUI documentSettings) {
        IEnumSetting enableAutoColorSetting = globalSettings.getEnumSetting(CATEGORY_AUTO_COLOR, CATEGORY_AUTO_COLOR, ON_OFF_OPTIONS, ON_OFF_OPTIONS[1]);
        enableAutoColorSetting.addValueObserver(value -> {
            this.enableAutoColor = ON_OFF_OPTIONS[1].equals(value);
            this.notifyObservers(ENABLE_AUTO_COLOR);
        });
        this.isSettingActive.add(ENABLE_AUTO_COLOR);
        DAWColor[] colors = DAWColor.values();
        int i = 0;
        while (i < colors.length) {
            DAWColor color = colors[i];
            IStringSetting setting = globalSettings.getStringSetting(color.getName(), CATEGORY_AUTO_COLOR, 256, "");
            int index = i++;
            Integer colorRegexIndex = COLOR_REGEX + index;
            setting.addValueObserver(value -> {
                this.colorRegEx.put(color, (String)value);
                this.notifyObservers(colorRegexIndex);
            });
            this.isSettingActive.add(colorRegexIndex);
        }
    }

    public boolean isEnableAutoColor() {
        return this.enableAutoColor;
    }

    public String getColorRegExValue(DAWColor color) {
        return this.colorRegEx.get((Object)color);
    }
}

