/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.oxi.one.mode;

import de.mossgrabers.controller.oxi.one.OxiOneConfiguration;
import de.mossgrabers.controller.oxi.one.controller.OxiOneControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.daw.GrooveParameterID;
import de.mossgrabers.framework.daw.IGroove;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.ITransport;
import de.mossgrabers.framework.daw.data.IItem;
import de.mossgrabers.framework.featuregroup.AbstractParameterMode;
import de.mossgrabers.framework.graphics.canvas.component.simple.TitleValueMenuComponent;
import de.mossgrabers.framework.parameter.IParameter;
import de.mossgrabers.framework.parameter.PlayPositionParameter;
import de.mossgrabers.framework.parameter.TempoParameter;
import de.mossgrabers.framework.parameterprovider.special.CombinedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FixedParameterProvider;
import de.mossgrabers.framework.parameterprovider.special.FourKnobProvider;

public class OxiOneTransportMode
extends AbstractParameterMode<OxiOneControlSurface, OxiOneConfiguration, IItem> {
    private static final String[] MENU = new String[]{"Tmp", "Shf", "Mtr", "Pos"};
    private static final String[] SHIFTED_MENU = new String[]{"Tick", "Shf", "Mtr", "Rept"};
    private int selectedParameter = 0;
    private final IParameter[] parameters = new IParameter[4];
    private final ITransport transport = this.model.getTransport();
    private final IGroove groove = this.model.getGroove();

    public OxiOneTransportMode(OxiOneControlSurface surface, IModel model) {
        super("Transport", surface, model, false);
        this.setControls(ContinuousID.createSequentialList(ContinuousID.KNOB1, 4));
        this.parameters[0] = new TempoParameter(model.getValueChanger(), this.transport, surface);
        this.parameters[1] = this.model.getGroove().getParameter(GrooveParameterID.SHUFFLE_AMOUNT);
        this.parameters[2] = this.transport.getMetronomeVolumeParameter();
        this.parameters[3] = new PlayPositionParameter(model.getValueChanger(), this.transport, surface);
        this.setParameterProvider(new FourKnobProvider(surface, new CombinedParameterProvider(new FixedParameterProvider(this.parameters[0]), new FixedParameterProvider(this.parameters[1]), new FixedParameterProvider(this.parameters[2]), new FixedParameterProvider(this.parameters[3])), ButtonID.SHIFT));
    }

    @Override
    public void updateDisplay() {
        IGraphicDisplay display = ((OxiOneControlSurface)this.surface).getGraphicsDisplay();
        String desc = this.parameters[this.selectedParameter].getName();
        String label = this.parameters[this.selectedParameter].getDisplayedValue();
        int value = this.selectedParameter > 0 && this.selectedParameter < 3 ? this.parameters[this.selectedParameter].getValue() : 0;
        display.addElement(new TitleValueMenuComponent(desc, label, ((OxiOneControlSurface)this.surface).isShiftPressed() ? SHIFTED_MENU : MENU, value, -1, -1, false));
        display.send();
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.setTouchedKnob(index, isTouched);
        if (!isTouched) {
            return;
        }
        if (((OxiOneControlSurface)this.surface).isShiftPressed()) {
            switch (index) {
                case 0: {
                    this.transport.toggleMetronomeTicks();
                    this.mvHelper.notifyMetronomeTicks();
                    break;
                }
                case 1: {
                    IParameter enabledParameter = this.groove.getParameter(GrooveParameterID.ENABLED);
                    if (enabledParameter == null) break;
                    enabledParameter.setNormalizedValue(enabledParameter.getValue() == 0 ? 1.0 : 0.0);
                    this.mvHelper.notifyGrooveEnablement();
                    return;
                }
                case 2: {
                    this.transport.toggleMetronome();
                    this.mvHelper.notifyMetronome();
                    break;
                }
                case 3: {
                    this.transport.toggleLoop();
                    this.mvHelper.notifyArrangerRepeat();
                }
            }
        } else {
            this.selectedParameter = index;
        }
    }
}

