/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ni.maschine.mk3.mode;

import de.mossgrabers.controller.ni.maschine.mk3.controller.MaschineControlSurface;
import de.mossgrabers.controller.ni.maschine.mk3.mode.BaseMode;
import de.mossgrabers.controller.ni.maschine.mk3.view.DrumView;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.display.ITextDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.IView;
import de.mossgrabers.framework.featuregroup.ViewManager;
import de.mossgrabers.framework.mode.INoteEditor;
import de.mossgrabers.framework.mode.INoteEditorMode;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.scale.Scales;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.Views;

public class DrumConfigurationMode
extends BaseMode {
    public DrumConfigurationMode(MaschineControlSurface surface, IModel model) {
        super("Drum Configuration", surface, model);
        this.selectedParam = 6;
    }

    @Override
    public void onKnobValue(int index, int value) {
        if (!this.model.canSelectedTrackHoldNotes()) {
            return;
        }
        int idx = index < 0 ? this.selectedParam : index;
        Scales scales = this.model.getScales();
        boolean inc = this.model.getValueChanger().isIncrease(value);
        ViewManager viewManager = ((MaschineControlSurface)this.surface).getViewManager();
        switch (idx) {
            case 6: 
            case 7: {
                ((DrumView)viewManager.get(Views.DRUM)).changeOctave(ButtonEvent.DOWN, inc, scales.getDrumDefaultOffset(), true, false);
                ((IView)viewManager.get(Views.DRUM)).updateNoteMapping();
                this.getNoteEditor().clearNotes();
                break;
            }
        }
    }

    private INoteEditor getNoteEditor() {
        return ((INoteEditorMode)((MaschineControlSurface)this.surface).getModeManager().get(Modes.NOTE)).getNoteEditor();
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        if (isTouched && ((MaschineControlSurface)this.surface).isDeletePressed()) {
            int idx;
            ((MaschineControlSurface)this.surface).setTriggerConsumed(ButtonID.DELETE);
            int n = idx = index < 0 ? this.selectedParam : index;
            if (idx == 6 || idx == 7) {
                ((DrumView)((MaschineControlSurface)this.surface).getViewManager().get(Views.DRUM)).resetOctave();
                ((IView)((MaschineControlSurface)this.surface).getViewManager().get(Views.DRUM)).updateNoteMapping();
                this.getNoteEditor().clearNotes();
            }
        }
    }

    @Override
    public void updateDisplay() {
        ITextDisplay d = ((MaschineControlSurface)this.surface).getTextDisplay().clear();
        Scales scales = this.model.getScales();
        int octave = scales.getDrumOffset();
        d.setBlock(0, 3, this.mark("Drum Offset", 6)).setBlock(1, 3, (octave > 0 ? "+" : "") + Integer.toString(octave));
        d.allDone();
    }

    @Override
    public void selectPreviousItem() {
    }

    @Override
    public void selectNextItem() {
    }
}

