/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.fire.mode;

import de.mossgrabers.controller.akai.fire.FireConfiguration;
import de.mossgrabers.controller.akai.fire.controller.FireControlSurface;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.controller.ContinuousID;
import de.mossgrabers.framework.controller.display.IGraphicDisplay;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.data.ISend;
import de.mossgrabers.framework.daw.data.ITrack;
import de.mossgrabers.framework.daw.data.bank.ISendBank;
import de.mossgrabers.framework.graphics.canvas.component.simple.TitleValueComponent;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.mode.track.TrackMode;
import de.mossgrabers.framework.parameterprovider.special.FourKnobProvider;
import de.mossgrabers.framework.parameterprovider.track.SelectedTrackParameterProvider;
import java.util.List;
import java.util.Optional;

public class FireTrackMode
extends TrackMode<FireControlSurface, FireConfiguration> {
    private static final Modes[] MODES = new Modes[]{Modes.VOLUME, Modes.PAN, Modes.SEND1, Modes.SEND2};
    private static final Modes[] ALT_MODES = new Modes[]{Modes.SEND3, Modes.SEND4, Modes.SEND5, Modes.SEND6};
    protected Modes selectedParameter = Modes.VOLUME;

    public FireTrackMode(FireControlSurface surface, IModel model) {
        this("Track", surface, model);
    }

    protected FireTrackMode(String name, FireControlSurface surface, IModel model) {
        super(name, surface, model, false, (List<ContinuousID>)null);
        this.setControls(ContinuousID.createSequentialList(ContinuousID.KNOB1, 4));
        this.setParameterProvider(new FourKnobProvider(surface, new SelectedTrackParameterProvider(model), ButtonID.ALT));
    }

    @Override
    public void updateDisplay() {
        this.updateMode();
        IGraphicDisplay display = ((FireControlSurface)this.surface).getGraphicsDisplay();
        Object desc = "Select";
        Object label = "a track";
        int value = -1;
        int vuLeft = -1;
        int vuRight = -1;
        boolean isPan = false;
        Optional trackOptional = this.model.getCurrentTrackBank().getSelectedItem();
        if (trackOptional.isPresent()) {
            ITrack track = (ITrack)trackOptional.get();
            vuLeft = track.getVuLeft();
            vuRight = track.getVuRight();
            desc = track.getPosition() + 1 + ": " + track.getName(9);
            ISendBank sendBank = track.getSendBank();
            switch (this.selectedParameter) {
                case VOLUME: {
                    label = "Vol: " + track.getVolumeStr();
                    value = track.getVolume();
                    break;
                }
                case PAN: {
                    label = "Pan: " + track.getPanStr();
                    value = track.getPan();
                    isPan = true;
                    break;
                }
                case SEND1: 
                case SEND2: 
                case SEND3: 
                case SEND4: 
                case SEND5: 
                case SEND6: {
                    int sendIndex = this.selectedParameter.ordinal() - Modes.SEND1.ordinal();
                    label = FireTrackMode.getSendLabel(sendBank, sendIndex);
                    value = FireTrackMode.getSendValue(sendBank, sendIndex);
                    break;
                }
            }
        }
        display.addElement(new TitleValueComponent((String)desc, (String)label, value, vuLeft, vuRight, isPan));
        display.send();
    }

    protected void updateMode() {
        int index = -1;
        Modes[] ms = ((FireControlSurface)this.surface).isPressed(ButtonID.ALT) ? MODES : ALT_MODES;
        for (int i = 0; i < ms.length; ++i) {
            if (ms[i] != this.selectedParameter) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            this.selectedParameter = ((FireControlSurface)this.surface).isPressed(ButtonID.ALT) ? ALT_MODES[index] : MODES[index];
        }
    }

    @Override
    public void onKnobTouch(int index, boolean isTouched) {
        this.selectedParameter = ((FireControlSurface)this.surface).isPressed(ButtonID.ALT) ? ALT_MODES[index] : MODES[index];
        this.setTouchedKnob(index, isTouched);
        Optional trackOptional = this.model.getCurrentTrackBank().getSelectedItem();
        if (!trackOptional.isPresent()) {
            return;
        }
        ITrack track = (ITrack)trackOptional.get();
        switch (this.selectedParameter) {
            case VOLUME: {
                if (isTouched && ((FireControlSurface)this.surface).isDeletePressed()) {
                    track.resetVolume();
                }
                track.touchVolume(isTouched);
                break;
            }
            case PAN: {
                if (isTouched && ((FireControlSurface)this.surface).isDeletePressed()) {
                    track.resetPan();
                }
                track.touchPan(isTouched);
                break;
            }
            case SEND1: 
            case SEND2: 
            case SEND3: 
            case SEND4: 
            case SEND5: 
            case SEND6: {
                int sendIndex = this.selectedParameter.ordinal() - Modes.SEND1.ordinal();
                ISend item = (ISend)track.getSendBank().getItem(sendIndex);
                if (isTouched && ((FireControlSurface)this.surface).isDeletePressed()) {
                    item.resetValue();
                }
                item.touchValue(isTouched);
                break;
            }
        }
    }

    private static String getSendLabel(ISendBank sendBank, int index) {
        int pos = index + 1;
        if (sendBank == null) {
            return "No FX " + pos;
        }
        ISend send = (ISend)sendBank.getItem(index);
        if (!send.doesExist()) {
            return "No FX " + pos;
        }
        return send.getName(4) + ": " + send.getDisplayedValue();
    }

    private static int getSendValue(ISendBank sendBank, int index) {
        if (sendBank == null) {
            return 0;
        }
        ISend send = (ISend)sendBank.getItem(index);
        return send.doesExist() ? send.getValue() : 0;
    }
}

