/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.akai.apcmini.view;

import de.mossgrabers.controller.akai.apcmini.APCminiConfiguration;
import de.mossgrabers.controller.akai.apcmini.controller.APCminiControlSurface;
import de.mossgrabers.controller.akai.apcmini.definition.IAPCminiControllerDefinition;
import de.mossgrabers.controller.akai.apcmini.view.APCminiView;
import de.mossgrabers.framework.controller.ButtonID;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.daw.clip.INoteClip;
import de.mossgrabers.framework.utils.ButtonEvent;
import de.mossgrabers.framework.view.sequencer.AbstractNoteSequencerView;

public class SequencerView
extends AbstractNoteSequencerView<APCminiControlSurface, APCminiConfiguration>
implements APCminiView {
    private final IAPCminiControllerDefinition definition;

    public SequencerView(APCminiControlSurface surface, IModel model, boolean useTrackColor, IAPCminiControllerDefinition definition) {
        super("Sequencer", surface, model, useTrackColor);
        this.definition = definition;
    }

    @Override
    public void onSelectTrack(int index, ButtonEvent event) {
        if (event != ButtonEvent.DOWN || !this.isActive()) {
            return;
        }
        switch (this.definition.swapShiftedTrackIndices(index)) {
            case 0: {
                this.onOctaveUp(event);
                break;
            }
            case 1: {
                this.onOctaveDown(event);
                break;
            }
            case 2: {
                this.onLeft(event);
                break;
            }
            case 3: {
                this.onRight(event);
                break;
            }
        }
        this.updateScale();
    }

    @Override
    public int getTrackButtonColor(int index) {
        int octave = this.scales.getOctave();
        INoteClip clip = this.getClip();
        switch (this.definition.swapShiftedTrackIndices(index)) {
            case 0: {
                return octave < 4 ? 1 : 0;
            }
            case 1: {
                return octave > -4 ? 1 : 0;
            }
            case 2: {
                return clip.doesExist() && clip.canScrollStepsBackwards() ? 1 : 0;
            }
            case 3: {
                return clip.doesExist() && clip.canScrollStepsForwards() ? 1 : 0;
            }
        }
        return 0;
    }

    @Override
    public String getButtonColorID(ButtonID buttonID) {
        int index = buttonID.ordinal() - ButtonID.SCENE1.ordinal();
        int res = 7 - index;
        boolean isKeyboardEnabled = this.model.canSelectedTrackHoldNotes();
        return isKeyboardEnabled && res == this.getResolutionIndex() ? "BUTTON_STATE_ON" : "BUTTON_STATE_OFF";
    }
}

