/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.controller;

public class ColorPaletteEntry {
    public static final int MAX_NUMBER_OF_RETRIES = 10;
    private static final int PALETTE_MESSAGE_OUT_ID = 3;
    private static final int PALETTE_MESSAGE_IN_ID = 4;
    private static final int MESSAGE_LENGTH = 17;
    private final int index;
    private final int red;
    private final int green;
    private final int blue;
    private int white;
    private State state = State.READ;
    private int readRetries = 0;
    private int writeRetries = 0;
    private long sendTimestamp;

    public ColorPaletteEntry(int index, int[] color) {
        this.index = index;
        this.red = color[0];
        this.green = color[1];
        this.blue = color[2];
    }

    public static boolean isValid(int[] data) {
        return data.length == 17 && data[6] == 4;
    }

    public boolean requiresUpdate(int[] data) {
        this.white = data[14] + (data[15] << 7);
        return this.red != data[8] + (data[9] << 7) || this.green != data[10] + (data[11] << 7) || this.blue != data[12] + (data[13] << 7);
    }

    public boolean incReadRetries() {
        ++this.readRetries;
        if (this.readRetries > 10) {
            this.state = State.DONE;
            return false;
        }
        this.state = State.READ_REQUESTED;
        this.sendTimestamp = System.currentTimeMillis();
        return true;
    }

    public boolean incWriteRetries() {
        ++this.writeRetries;
        if (this.writeRetries > 10) {
            this.state = State.DONE;
            return false;
        }
        this.state = State.READ;
        this.sendTimestamp = System.currentTimeMillis();
        return true;
    }

    public void setWrite() {
        this.state = State.WRITE;
    }

    public void setDone() {
        this.state = State.DONE;
    }

    public State getState() {
        return this.state;
    }

    public int[] createUpdateMessage() {
        int[] data = new int[]{3, this.index, this.red % 128, this.red / 128, this.green % 128, this.green / 128, this.blue % 128, this.blue / 128, this.white % 128, this.white / 128};
        return data;
    }

    public long getSendTimestamp() {
        return this.sendTimestamp;
    }

    static enum State {
        READ,
        READ_REQUESTED,
        WRITE,
        DONE;

    }
}

