/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.controller.ableton.push.command.trigger;

import de.mossgrabers.controller.ableton.push.PushConfiguration;
import de.mossgrabers.controller.ableton.push.PushVersion;
import de.mossgrabers.controller.ableton.push.controller.PushControlSurface;
import de.mossgrabers.framework.command.core.AbstractTriggerCommand;
import de.mossgrabers.framework.daw.IModel;
import de.mossgrabers.framework.featuregroup.ModeManager;
import de.mossgrabers.framework.mode.Modes;
import de.mossgrabers.framework.utils.ButtonEvent;

public class SetupCommand
extends AbstractTriggerCommand<PushControlSurface, PushConfiguration> {
    private final PushVersion pushVersion;

    public SetupCommand(PushVersion pushVersion, IModel model, PushControlSurface surface) {
        super(model, surface);
        this.pushVersion = pushVersion;
    }

    @Override
    public void execute(ButtonEvent event, int velocity) {
        if (event != ButtonEvent.DOWN) {
            return;
        }
        ModeManager modeManager = ((PushControlSurface)this.surface).getModeManager();
        Modes mode = this.getMode();
        if (modeManager.isActive(new Modes[]{mode})) {
            modeManager.restore();
        } else {
            modeManager.setTemporary(mode);
        }
    }

    private Modes getMode() {
        if (this.pushVersion != PushVersion.VERSION_1) {
            return Modes.SETUP;
        }
        if (((PushControlSurface)this.surface).isShiftPressed()) {
            return Modes.CONFIGURATION;
        }
        return Modes.USER;
    }
}

