/*
 * Decompiled with CFR 0.152.
 */
package de.mossgrabers.nativefiledialogs.linux;

import de.mossgrabers.nativefiledialogs.AbstractNativeFileDialogs;
import de.mossgrabers.nativefiledialogs.FileFilter;
import de.mossgrabers.nativefiledialogs.ProcessResult;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class NativeLinuxFileDialogs
extends AbstractNativeFileDialogs {
    private boolean isZenityPresent = false;

    public NativeLinuxFileDialogs(File currentDirectory) {
        super(currentDirectory);
        this.detectZenity();
    }

    @Override
    public File selectFile(String title, FileFilter ... filters) throws IOException {
        File file = this.selectFile(false, false, title, filters);
        return file != null && !file.isDirectory() ? file : null;
    }

    @Override
    public File selectNewFile(String title, FileFilter ... filters) throws IOException {
        File file = this.selectFile(false, true, title, filters);
        return file != null && !file.isDirectory() ? file : null;
    }

    @Override
    public File selectFolder(String title) throws IOException {
        return this.selectFile(true, false, title, new FileFilter[0]);
    }

    private File selectFile(boolean isDirectory, boolean doSave, String title, FileFilter ... filters) throws IOException {
        ProcessResult processResult;
        String result;
        if (!this.isZenityPresent) {
            throw new IOException("Please install zenity from the command line: 'sudo apt install zenity'");
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add("zenity");
        params.add("--file-selection");
        if (isDirectory) {
            params.add("--directory");
        }
        if (this.currentDirectory != null && this.currentDirectory.exists()) {
            Object dir = this.currentDirectory;
            if (isDirectory && ((File)dir).isFile()) {
                dir = ((File)dir).getParentFile();
            }
            params.add(String.format("--filename=%s", ((File)dir).getAbsolutePath()));
        }
        if (doSave) {
            params.add("--save");
            params.add("--confirm-overwrite");
        }
        if (title != null && !title.isEmpty()) {
            params.add(String.format("--title=%s", title));
        }
        if (filters.length > 0) {
            for (FileFilter filter : filters) {
                StringBuilder sb = new StringBuilder();
                sb.append("--file-filter=").append(filter.getLabel()).append(" | ");
                for (String extension : filter.getExtensions()) {
                    sb.append("*.").append(extension).append(" ");
                }
                params.add(sb.toString().trim());
            }
        }
        return (result = (processResult = NativeLinuxFileDialogs.executeProcess(params.toArray(new String[params.size()]))).getResult()).isEmpty() ? null : new File(result);
    }

    private void detectZenity() {
        try {
            this.isZenityPresent = NativeLinuxFileDialogs.executeProcess(new String[]{"which", "zenity"}).getExitCode() == 0;
        }
        catch (IOException ex) {
            this.isZenityPresent = false;
        }
    }
}

